% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier_norm}
\alias{efourier_norm}
\title{Normalized Fourier coefficients}
\usage{
efourier_norm(x, start = FALSE)
}
\arguments{
\item{x}{An object computed with \code{\link[=efourier]{efourier()}}.}

\item{start}{Logical value telling whether the position of the starting point
has to be preserved or not.}
}
\value{
A list with the following components:
\itemize{
\item \code{A}, \code{B}, \code{C}, \code{D} for harmonic coefficients.
\item \code{size} the magnitude of the semi-major axis of the first fitting ellipse.
\item \code{theta} angle, in radians, between the starting and the semi-major axis of
the first fitting ellipse.
\item \code{psi} orientation of the first fitting ellipse
\item \code{a0} and \code{c0}, harmonic coefficients.
\item \code{lnef} the concatenation of coefficients.
\item \code{nharm} the number of harmonics used.
}
}
\description{
The first harmonic defines an ellipse that best fits the outlines. One can
use the parameters of the first harmonic to “normalize” the data so that they
can be invariant to size, rotation, and starting position of the outline
trace. This approach is referred to in the literature as the normalized
elliptic Fourier. \code{\link[=efourier_norm]{efourier_norm()}} calculates a new set of Fourier
coefficients \code{An}, \code{Bn}, \code{Cn}, \code{Dn} that one can use for further multivariate
analyses (Claude, 2008).
}
\details{
Adapted from Claude (2008). pp. 226.
}
\examples{
library(pliman)
leaf1 <- contours[[4]]
plot_polygon(leaf1)

# compute the Fourier coefficients
ef <- efourier(leaf1)
efourier_coefs(ef)

# Normalized Fourier coefficients

efn <- efourier_norm(ef)
efourier_coefs(efn)
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
