% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.fitmixture.R
\name{print.fitmixture}
\alias{print.fitmixture}
\title{Print a "fitmixture" Object}
\usage{
\method{print}{fitmixture}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{the result of a call to \code{fit_mixture()}}

\item{digits}{the number of significant digits to print}

\item{...}{for additional print arguments}
}
\value{
invisibly returns the \code{fit_mixture()} object that is provided as an argument
}
\description{
Print call and outcome model coefficients from a \code{fit_mixture()} object
}
\examples{
## commonness score of first and last names used for linkage
mformula <- ~commf + comml
## hand-linked records are considered "safe" matches
safematches <- ifelse(lifem$hndlnk =="Hand-Linked At Some Level", TRUE, FALSE)
## overall mismatch rate in the data set is assumed to be ~ 0.05
mrate <- 0.05
fit <- fit_mixture(age_at_death ~ poly(unit_yob, 3, raw = TRUE), data = lifem,
                   family = "gaussian", mformula, safematches, mrate)

print(fit)

}
