% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitBB.R
\name{fitBB}
\alias{fitBB}
\title{Fit Ball-Berry type models of stomatal conductance}
\usage{
fitBB(data, varnames = list(ALEAF = "Photo", GS = "Cond", VPD = "VpdL",
  Ca = "CO2S", RH = "RH"), gsmodel = c("BBOpti", "BBLeuning",
  "BallBerry", "BBOptiFull"), fitg0 = FALSE)
}
\arguments{
\item{data}{Input dataframe, containing all variables needed to fit the model.}

\item{varnames}{List of names of variables in the input dataframe. Relative humidity (RH) is only 
needed when the original Ball-Berry model is to be fit.}

\item{gsmodel}{One of BBOpti (Medlyn et al. 2011), BBLeuning (Leuning 1995), BallBerry (Ball et al. 1987), or BBOptiFull (Medlyn et al. 2011 but with an extra parameter gk, see Duursma et al. 2013)}

\item{fitg0}{If TRUE, also fits the intercept term (g0, the 'residual conductance'). Default is FALSE.}
}
\value{
A list with several components, most notably \code{fit}, the object returned by \code{nls}. If the user needs more information on the goodness of fit etc, please further analyze this object. For example, use the \pkg{broom} package for quick summaries. Or use \code{\link{confint}} to calculate confidence intervals on the fitted parameters.
}
\description{
Fits one of three versions of the Ball-Berry type stomatal conductance models to 
observations of stomatal conductance (gs), photosynthesis (A), atmospheric CO2 concentration (Ca) 
and vapour pressure deficit (VPD).
}
\details{
Note that unlike in some publications (e.g. Leuning et al. 1995), the models fit here do not include the CO2 compensation point. This correction may be necessary but can be added by the user (by replacing Ca with the corrected term).

Note that all models use atmospheric CO2 concentration (Ca) instead of, as sometimes argued, intercellular CO2 concentration (Ci). Using the latter makes these models far more difficult to use in practice, and we have found no benefit of using Ci instead of Ca (and Ca arises from an optimization argument, see Medlyn et al. 2011). The idea that we should use Ci because 'stomata sense Ci, not Ca' is probably not valid (or at least, not sufficient), and note that Ci plays a central role in the steady-state solution to stomatal conductance anyway (see \code{\link{Photosyn}}). 

To fit the Ball-Berry models for each group in a dataframe, for example species, see the \code{\link{fitBBs}} function.
}
\examples{

\dontrun{
# If 'mydfr' is a dataframe with 'Photo', 'Cond', 'VpdL' and 'CO2S', you can do:
myfit <- fitBB(mydfr, gsmodel = "BBOpti")

# Coefficients and a message:
myfit

# Coefficients only
coef(myfit)

# If you have a species variable, and would like to fit the model for each species,
# use fitBBs (see its help page ?fitBBs)
myfits <- fitBBs(mydfr, "species")
}
}
\references{
Ball, J.T., Woodrow, I.E., Berry, J.A., 1987. A model predicting stomatal conductance and its contribution to the control of photosynthesis under different environmental conditions., in: Biggins, J. (Ed.), Progress in Photosynthesis Research. Martinus-Nijhoff Publishers, Dordrecht, the Netherlands, pp. 221-224.

Leuning, R. 1995. A critical-appraisal of a combined stomatal-photosynthesis model for C-3 plants. Plant Cell and Environment. 18:339-355.

Medlyn, B.E., R.A. Duursma, D. Eamus, D.S. Ellsworth, I.C. Prentice, C.V.M. Barton, K.Y. Crous, P. De Angelis, M. Freeman and L. Wingate. 2011. Reconciling the optimal and empirical approaches to modelling stomatal conductance. Global Change Biology. 17:2134-2144.

Duursma, R.A., Payton, P., Bange, M.P., Broughton, K.J., Smith, R.A., Medlyn, B.E., Tissue, D.T., 2013. Near-optimal response of instantaneous transpiration efficiency to vapour pressure deficit, temperature and [CO2] in cotton (Gossypium hirsutum L.). Agricultural and Forest Meteorology 168, 168-176. doi:10.1016/j.agrformet.2012.09.005
}
