% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{pkgcache-package}
\alias{pkgcache}
\alias{pkgcache-package}
\title{Cache for package data and metadata}
\description{
Metadata and package cache for CRAN-like repositories.
     This is a utility package to be used by package management tools
     that want to take advantage of caching.
}
\details{
Metadata and package cache for CRAN-like repositories. This is a utility
package to be used by package management tools that want to take
advantage of caching.
\subsection{Installation}{

You can install the released version of pkgcache from
\href{https://CRAN.R-project.org}{CRAN} with:\if{html}{\out{<div class="r">}}\preformatted{install.packages("pkgcache")
}\if{html}{\out{</div>}}
}

\subsection{Metadata cache}{

\code{meta_cache_list()} lists all packages in the metadata cache. It
includes Bioconductor package, and all versions (i.e. both binary and
source) of the packages for the current platform and R version.\if{html}{\out{<div class="r">}}\preformatted{library(pkgcache)
meta_cache_list()
#> # A tibble: 39,306 x 32
#>    package version depends suggests license imports linkingto archs
#>    <chr>   <chr>   <chr>   <chr>    <chr>   <chr>   <chr>     <chr>
#>  1 A3      1.0.0   R (>= ~ randomF~ GPL (>~ <NA>    <NA>      <NA> 
#>  2 AATtoo~ 0.0.1   R (>= ~ <NA>     GPL-3   magrit~ <NA>      <NA> 
#>  3 ABACUS  1.0.0   R (>= ~ rmarkdo~ GPL-3   ggplot~ <NA>      <NA> 
#>  4 ABC.RAP 0.9.0   R (>= ~ knitr, ~ GPL-3   graphi~ <NA>      <NA> 
#>  5 ABCana~ 1.2.1   R (>= ~ <NA>     GPL-3   plotrix <NA>      <NA> 
#>  6 ABCopt~ 0.15.0  <NA>    testtha~ MIT + ~ Rcpp, ~ Rcpp      i386~
#>  7 ABCp2   1.2     MASS    <NA>     GPL-2   <NA>    <NA>      <NA> 
#>  8 ABHgen~ 1.0.1   <NA>    knitr, ~ GPL-3   ggplot~ <NA>      <NA> 
#>  9 ABPS    0.3     <NA>    testthat GPL (>~ kernlab <NA>      <NA> 
#> 10 ACA     1.1     R (>= ~ <NA>     GPL     graphi~ <NA>      <NA> 
#> # ... with 39,296 more rows, and 24 more variables: enhances <chr>,
#> #   os_type <chr>, priority <chr>, license_is_foss <chr>,
#> #   license_restricts_use <chr>, repodir <chr>, platform <chr>,
#> #   rversion <chr>, needscompilation <chr>, ref <chr>, type <chr>,
#> #   direct <lgl>, status <chr>, target <chr>, mirror <chr>,
#> #   sources <list>, filesize <int>, sha256 <chr>, sysreqs <chr>,
#> #   built <chr>, published <dttm>, deps <list>, md5sum <chr>, path <chr>
}\if{html}{\out{</div>}}

\code{meta_cache_deps()} and \code{meta_cache_revdeps()} can be used to look up
dependencies and reverse dependencies.

The metadata is updated automatically if it is older than seven days,
and it can also be updated manually with \code{meta_cache_update()}.

See the \code{cranlike_metadata_cache} R6 class for a lower level API, and
more control.
}

\subsection{Package cache}{

Package management tools may use the \verb{pkg_cache_*} functions and in
particular the \code{package_cache} class, to make use of local caching of
package files.

The \verb{pkg_cache_*} API is high level, and uses a user level cache:\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_summary()
#> $cachepath
#> [1] "C:\\Users\\csard\\AppData\\Local\\R-pkg\\R-pkg\\Cache/pkg"
#> 
#> $files
#> [1] 945
#> 
#> $size
#> [1] 1687305158
}\if{html}{\out{</div>}}\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_list()
#> # A tibble: 945 x 10
#>    fullpath path  package url   etag  sha256 version platform built
#>    <chr>    <glu> <chr>   <chr> <chr> <chr>  <chr>   <chr>    <int>
#>  1 "C:\\Us~ bin/~ assert~ http~ "\"a~ ccc34~ 0.2.1   windows     NA
#>  2 "C:\\Us~ bin/~ callr   http~ "\"1~ fdd92~ 3.2.0   windows     NA
#>  3 "C:\\Us~ bin/~ backpo~ http~ "\"1~ 8bf70~ 1.1.4   windows     NA
#>  4 "C:\\Us~ bin/~ cli     http~ "\"1~ 7aac3~ 1.1.0   windows     NA
#>  5 "C:\\Us~ bin/~ cliapp  http~ "\"2~ 65bfe~ 0.1.0   windows     NA
#>  6 "C:\\Us~ bin/~ desc    http~ "\"2~ b69c8~ 1.2.0   windows     NA
#>  7 "C:\\Us~ bin/~ ellips~ http~ "\"7~ ce5c4~ 0.1.0   windows     NA
#>  8 "C:\\Us~ bin/~ crayon  http~ "\"a~ bd143~ 1.3.4   windows     NA
#>  9 "C:\\Us~ bin/~ digest  http~ "\"2~ 72423~ 0.6.18  windows     NA
#> 10 "C:\\Us~ bin/~ glue    http~ "\"2~ f5e83~ 1.3.1   windows     NA
#> # ... with 935 more rows, and 1 more variable: vignettes <chr>
}\if{html}{\out{</div>}}\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_find(package = "dplyr")
#> # A tibble: 3 x 10
#>   fullpath path  package url   etag  sha256 version platform built
#>   <chr>    <glu> <chr>   <chr> <chr> <chr>  <chr>   <chr>    <int>
#> 1 "C:\\Us~ bin/~ dplyr   http~ "\"1~ da597~ 1.0.1   windows     NA
#> 2 "C:\\Us~ bin/~ dplyr   http~ "\"1~ 2940a~ 1.0.2   windows     NA
#> 3 "C:\\Us~ bin/~ dplyr   http~ "\"1~ b32d2~ 1.0.2   windows     NA
#> # ... with 1 more variable: vignettes <chr>
}\if{html}{\out{</div>}}

\code{pkg_cache_add_file()} can be used to add a file,
\code{pkg_cache_delete_files()} to remove files, \code{pkg_cache_get_files()} to
copy files out of the cache.

The \code{package_cache} class provides a finer API.
}

\subsection{Bioconductor support}{

Both the metadata cache and the package cache support Bioconductor by
default, automatically. See the \code{BioC_mirror} option and the
\code{R_BIOC_MIRROR} and \code{R_BIOC_VERSION} environment variables below to
configure pkgcache’s Bioconductor support.
}

\subsection{Package Options}{
\itemize{
\item The \code{BioC_mirror} option can be used to select a Bioconductor
mirror. This takes priority over the \code{R_BIOC_MIRROR} environment
variable.
\item \code{pkgcache_timeout} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}.
\item \code{pkgcache_connecttimeout} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds
to the \href{https://curl.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}.
\item \code{pkgcache_low_speed_limit} and \code{pkgcache_low_speed_time} are used
for a more sensible HTTP timeout. If the download speed is less than
\code{pkgcache_low_speed_limit} bytes per second for at least
\code{pkgcache_low_speed_time} seconds, the download errors. They
correspond to the
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options.
}
}

\subsection{Package environment variables}{
\itemize{
\item The \code{R_BIOC_VERSION} environment variable can be used to override
the default Bioconductor version detection and force a given
version. E.g. this can be used to force the development version of
Bioconductor.
\item The \code{R_BIOC_MIRROR} environment variable can be used to select a
Bioconductor mirror. The \code{BioC_mirror} option takes priority over
this, if set.
\item \code{PKGCACHE_TIMEOUT} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}. The
\code{pkgcache_timeout} option has priority over this, if set.
\item \code{PKGCACHE_CONNECTTIMEOUT} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds
to the \href{https://curl.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}. The
\code{pkgcache_connecttimeout} option takes precedence over this, if set.
\item \code{PKGCACHE_LOW_SPEED_LIMIT} and \code{PKGCACHE_LOW_SPEED_TIME} are used
for a more sensible HTTP timeout. If the download speed is less than
\code{PKGCACHE_LOW_SPEED_LIMIT} bytes per second for at least
\code{PKGCACHE_LOW_SPEED_TIME} seconds, the download errors. They
correspond to the
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options. The \code{pkgcache_low_speed_time} and
\code{pkgcache_low_speed_limit} options have priority over these
environment variables, if they are set.
\item \code{R_PKG_CACHE_DIR} is used for the cache directory, if set.
(Otherwise \code{rappdirs::user_cache_dir()} is used, see also
\code{meta_cache_summary()} and \code{pkg_cache_summary()}).
}
}

\subsection{Code of Conduct}{

Please note that the ‘pkgcache’ project is released with a \href{https://github.com/r-lib/pkgcache/blob/master/.github/CODE_OF_CONDUCT.md}{Contributor Code of Conduct}.
By contributing to this project, you agree to abide by its terms.
}

\subsection{License}{

MIT (c) \href{https://www.rstudio.com/}{RStudio Inc}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgcache#readme}
  \item Report bugs at \url{https://github.com/r-lib/pkgcache/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

}
