% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_bg.R
\name{sprinkle_bg}
\alias{sprinkle_background}
\alias{sprinkle_bg}
\alias{sprinkle_bg.default}
\alias{sprinkle_bg.dust_list}
\title{Sprinkle the Background Color of a Cell}
\usage{
sprinkle_bg(x, rows = NULL, cols = NULL, bg, part = c("body", "head",
  "foot", "interfoot"), fixed = FALSE, recycle = c("none", "rows", "cols",
  "columns"), ...)

\method{sprinkle_bg}{default}(x, rows = NULL, cols = NULL, bg,
  part = c("body", "head", "foot", "interfoot"), fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_bg}{dust_list}(x, rows = NULL, cols = NULL, bg,
  part = c("body", "head", "foot", "interfoot"), fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"), ...)

sprinkle_background(x, rows = NULL, cols = NULL, bg, part = c("body",
  "head", "foot", "interfoot"), fixed = FALSE, recycle = c("none", "rows",
  "cols", "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{bg}{\code{character(1)} A character string giving a color for the 
background of the chosen cells.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Background colors may be used to highlight the contents 
  of cells, rows, or columns.  Most commonly, backgrounds are used to
  provide row discrimination; the \code{sprinkle_bg_pattern} function
  is better suited to that purpose.
}
\details{
Colors may be a dvips color name, or in the rgb(R, G, B), 
rgba(R, G, B, A), #RRGGBB, or #RRGGBBAA formats. See 
\url{http://nutterb.github.io/pixiedust/colors.html} for additional
details.
  
This sprinkle is ignored in console and markdown outputs.  HTML output
will accept any of the color formats and recognize transparency.  LaTeX
output will accept any of the color formats but ignore transparency.

As long as \code{bg} is required to be a \code{character(1)}, the 
\code{recycle} argument is kind of useless. It is included to maintain
consistency with the \code{index_to_sprinkle} function. Future development
may permit a character vector of colors.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements \code{bg} column
   in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{bg} is not a \code{character(1)}
 \item Casts an error if \code{bg} is not a valid color format.
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{sprinkle}}, \code{\link{sprinkle_bg_pattern}}, 
  \code{\link{index_to_sprinkle}}
}

