% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotOpenXlsxStyles.R
\docType{class}
\name{PivotOpenXlsxStyles}
\alias{PivotOpenXlsxStyles}
\title{A class that defines a collection of Excel styles as used by the openxlsx
package.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotOpenXlsxStyles
}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define styles/a theme for a pivot table.
}
\description{
The PivotOpenXlsxStyles class stores a collection of PivotTableOpenXlsx style
objects.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new set of styles, specifying the field
  values documented above.}

  \item{\code{findNamedStyle(baseStyleName)}}{Find an existing openxlsx style
  matching the name of a base style.}
  \item{\code{findOrAddStyle(action="findOrAdd", baseStyleName=NULL,
  isBaseStyle=NULL, style=NULL, mapFromCss=TRUE)}}{Find an existing openxlsx
  style and/or add a new openxlsx style matching a base style and/or
  PivotStyle object.}
  \item{\code{addNamedStyles(mapFromCss=TRUE)}}{Populate the OpenXlsx styles
  based on the styles defined in the pivot table.}
  \item{\code{asList()}}{Get a list representation of the styles.}
  \item{\code{asJSON()}}{Get a JSON representation of the styles.}
  \item{\code{asString()}}{Get a text representation of the styles.}
}
}

\examples{
# This class is used internally by the Pivot Table.
}
\keyword{datasets}
