% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_get}
\alias{pin_get}
\title{Retrieve Pin}
\usage{
pin_get(name, board = NULL, cache = TRUE, ...)
}
\arguments{
\item{name}{The name of the pin.}

\item{board}{The board where this pin will be retrieved from.}

\item{cache}{Should the pin cache be used? Defaults to \code{TRUE}.}

\item{...}{Additional parameters.}
}
\description{
Retrieves a pin by name from the local or given board.
}
\details{
\code{pin_get()} retrieves a pin by name and, by default, from the local board.
You can use the \code{board} parameter to specify which board to retrieve a pin from.
If a board is not specified, it will use \code{pin_find()} to find the pin across
all boards and retrieve the one that matches by name.
}
\examples{

library(pins)

# define local board
board_register_local(cache = tempfile())

# cache the mtcars dataset
pin(mtcars)

# retrieve the mtcars pin
pin_get("mtcars")

# retrieve mtcars pin from packages board
pin_get("easyalluvial/mtcars2", board = "packages")
}
