% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cima-.r
\name{plot.cima}
\alias{plot.cima}
\title{Plot Results}
\usage{
\method{plot}{cima}(x, y = NULL, title = "Forest plot",
  base_size = 16, base_family = "", digits = 3, studylabel = NULL,
  ...)
}
\arguments{
\item{x}{`cima` object to plot}

\item{y}{is not used}

\item{title}{graph title}

\item{base_size}{base font size}

\item{base_family}{base font family}

\item{digits}{a value for digits specifies the minimum number
of significant digits to be printed in values.}

\item{studylabel}{labels for each study}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A function for plotting of `cima` objects.
}
\examples{
data(sbp, package = "pimeta")
ciex <- pimeta::cima(sbp$y, sbp$sigmak, method = "DL")
cairo_pdf("forestplot.pdf", width = 6, height = 3, family = "Arial")
plot(ciex, digits = 2, base_size = 10, studylabel = sbp$label)
dev.off()
}
