% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-hts.r
\name{pima_hts}
\alias{pima_hts}
\alias{htsdl}
\title{Higgins--Thompson--Spiegelhalter prediction interval}
\usage{
pima_hts(y, sigma, alpha = 0.05)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}
}
\value{
\itemize{
\item \code{muhat}: the average treatment effect estimate \eqn{\hat{\mu}}.
\item \code{lci}, \code{lci}: the lower and upper confidence limits \eqn{\hat{\mu}_l} and \eqn{\hat{\mu}_u}.
\item \code{lpi}, \code{lpi}: the lower and upper prediction limits \eqn{\hat{c}_l} and \eqn{\hat{c}_u}.
\item \code{tau2h}: the estimate for \eqn{\tau^2}.
}
}
\description{
A subroutine for the Higgins--Thompson--Spiegelhalter PI
based on the DerSimonian-Laird estimator (Higgins et al., 2009)
}
\examples{
data(sbp, package = "pimeta")
pimeta::pima_hts(sbp$y, sbp$sigmak)
# 
# Prediction Interval for Random-Effects Meta-Analysis
# 
# Higgins-Thompson-Spiegelhalter prediction interval
#  Heterogeneity variance: DerSimonian-Laird
#  SE for average treatment effect: standard
# 
# Average treatment effect [95\%PI]:
#  -0.3341 [-0.7598, 0.0917]
# 
# Average treatment effect [95\%CI]:
#  -0.3341 [-0.5068, -0.1613]
# 
# Heterogeneity variance (tau^2):
#  0.0282
# 
}
\references{
Higgins, J. P. T, Thompson, S. G., Spiegelhalter, D. J. (2009).
A re-evaluation of random-effects meta-analysis.
\emph{J R Stat Soc Ser A Stat Soc.}
\strong{172}(1): 137-159.
}
\seealso{
\code{\link[=pima]{pima()}}.
}
