% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_download_url.R
\name{pb_download_url}
\alias{pb_download_url}
\title{Get the download url of a given file}
\usage{
pb_download_url(
  file = NULL,
  repo = guess_repo(),
  tag = "latest",
  .token = get_token()
)
}
\arguments{
\item{file}{name or vector of names of files to be downloaded. If \code{NULL},
all assets attached to the release will be downloaded.}

\item{repo}{Repository name in format "owner/repo". Will guess the current
repo if not specified.}

\item{tag}{tag for the GitHub release to which this data should be attached.}

\item{.token}{GitHub authentication token, see \verb{[gh::gh_token()]}}
}
\value{
the URL to download a file
}
\description{
Returns the URL download for a public file. This can be useful when writing
scripts that may want to download the file directly without introducing any
dependency on \code{piggyback} or authentication steps.
}
\examples{
\dontrun{

pb_download_url("iris.tsv.xz",
                repo = "cboettig/piggyback-tests",
                tag = "v0.0.1")

}
}
