% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pif_combine.R
\name{pif.combine}
\alias{pif.combine}
\title{Combine point estimates of PIF from different subpopulations}
\usage{
pif.combine(pif_vector, paf_vector, proportions)
}
\arguments{
\item{pif_vector}{Vector containing \code{\link{pif}}s for each specific
subpopulation.}

\item{paf_vector}{Vector containing \code{\link{paf}}s for each specific
subpopulation.}

\item{proportions}{Vector establishing the proportion of individuals in each
subpopulation.}
}
\value{
overall_pif An overall point-estimate of \code{pif} combining all subpopulations.
}
\description{
Function for fast-computing an overall \code{\link{pif}} from
  subpopulation \code{\link{pif}}s and \code{\link{paf}}s.
}
\details{
The subpopulations considered should not contain common elements.
}
\note{
To combine \code{pif}s both \code{pif}s and \code{paf}s are required.
}
\examples{

#Example 1
#-------------

#Estimate PAF for each subpopulation
pafmen   <- paf(X = data.frame(2.7), thetahat = 0.12, rr = function(X, theta){X*theta + 1},
                Xvar = 0.11, method = "approximate")
pafwomen <- paf(X = data.frame(3.1), thetahat = 0.12, rr = function(X, theta){exp(X*theta/3)},
                Xvar = 0.17, method = "approximate")

#Estimate PIF for each subpopulation
pifmen   <- pif(X = data.frame(2.7), thetahat = 0.12, rr = function(X, theta){X*theta + 1}, 
                cft = function(X){X/2}, Xvar = 0.11, method = "approximate")
pifwomen <- pif(X = data.frame(3.1), thetahat = 0.12, rr = function(X, theta){exp(X*theta/3)},
                cft = function(X){X/2}, Xvar = 0.17, method = "approximate")

#Combine estimates
pif.combine(c(pifmen, pifwomen), c(pafmen, pafwomen), c(0.45, 0.55))  


}
\seealso{
See \code{\link{paf}} for Population Attributable Fraction estimation, 
  \code{\link{pif}} for Population Impact Fraction estimation, and 
  \code{\link{paf.combine}} for combining several PAF.
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
