% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_shape.R
\name{pp_shape}
\alias{pp_shape}
\title{Shape object for generating various grobs}
\usage{
pp_shape(label = "rect", theta = 90, radius = 0.2, back = FALSE)
}
\arguments{
\item{label}{Label of the shape.  One of \describe{
     \item{\dQuote{circle}}{Circle.}
     \item{\dQuote{convexN}}{An \code{N}-sided convex polygon.
                             \code{theta} controls which direction the first vertex is drawn.}
     \item{\dQuote{concaveN}}{A \dQuote{star} (concave) polygon with \code{N} \dQuote{points}.
                             \code{theta} controls which direction the first point is drawn.
                             \code{radius} controls the distance of the \dQuote{inner} vertices from the center.}
     \item{\dQuote{halma}}{A 2D outline of a \dQuote{Halma pawn}.}
     \item{\dQuote{kite}}{\dQuote{Kite} quadrilateral shape.}
     \item{\dQuote{meeple}}{A 2D outline of a \dQuote{meeple}.}
     \item{\dQuote{oval}}{Oval.}
     \item{\dQuote{pyramid}}{An \dQuote{Isosceles} triangle whose base is the bottom of the viewport.
                             Typically used to help draw the face of the \dQuote{pyramid} piece.}
     \item{\dQuote{rect}}{Rectangle.}
     \item{\dQuote{roundrect}}{\dQuote{Rounded} rectangle.  \code{radius} controls curvature of corners.}
}}

\item{theta}{\code{convex} and \code{concave} polygon shapes
use this to determine where the first point is drawn.}

\item{radius}{\code{concave} polygon and \code{roundrect} use this
to control appearance of the shape.}

\item{back}{Whether the shape should be reflected across a vertical line in the middle of the viewport.}
}
\description{
\code{pp_shape()} creates an R6 object with methods for creating various shape based grobs.
}
\details{
\code{pp_shape} objects serve the following purposes:\enumerate{
 \item{Make it easier for developers to customize game piece appearances
       either through a "grob_fn" or "op_grob_fn" styles in \code{pp_cfg()}
       or manipulate a piece post drawing via functions like \code{grid::grid.edit()}.}
 \item{Used internally to generate \code{piecepackr}'s built-in game piece grobs.}
  }
}
\section{\code{pp_shape} R6 Class Method Arguments}{
\describe{
\item{\code{mat_width}}{Numeric vector of mat widths.}
\item{\code{clip}}{\dQuote{clip grob} to perform polyclip operation with.
                   See \code{\link[gridGeometry]{grid.polyclip}} for more info.}
\item{\code{op}}{Polyclip operation to perform.
                 See \code{\link[gridGeometry]{grid.polyclip}} for more info.}
\item{\code{name}}{Grid grob \code{name} value.}
\item{\code{gp}}{Grid \code{gpar} list.  See \code{\link[grid]{gpar}} for more info.}
\item{\code{vp}}{Grid viewport or \code{NULL}.}
}
}

\section{\code{pp_shape} R6 Class Methods}{
\describe{
\item{\code{checkers(name = NULL, gp = gpar(), vp = NULL)}}{Returns a grob of checkers for that shape.}
\item{\code{gridlines(name = NULL, gp = gpar(), vp = NULL)}}{Returns a grob of gridlines for that shape.}
\item{\code{hexlines(name = NULL, gp = gpar(), vp = NULL)}}{Returns a grob of hexlines for that shape.}
\item{\code{mat(mat_width = 0, name = NULL, gp = gpar(), vp = NULL)}}{
   Returns a grob for a matting \dQuote{mat} for that shape.}
\item{\code{polyclip(clip, op = "intersection", name = NULL, gp = gpar(), vp = NULL)}}{
   Returns a grob that is an \dQuote{intersection}, \dQuote{minus}, \dQuote{union}, or \dQuote{xor} of another grob.
   Note unlike \code{gridGeometry::polyclipGrob} it can directly work with a \code{pieceGrob} "clip grob" argument.}
\item{\code{shape(name = NULL, gp = gpar(), vp = NULL)}}{Returns a grob of the shape.}
}
}

\section{\code{pp_shape} R6 Class Active Bindings}{
\describe{
\item{\code{label}}{The shape's label.}
\item{\code{theta}}{The shape's theta.}
\item{\code{radius}}{The shape's radius.}
\item{\code{back}}{A boolean of whether this is the shape's \dQuote{back} side.}
\item{\code{npc_coords}}{A named list of \dQuote{npc} coordinates along the perimeter of the shape.}
}
}

\examples{
 if (require("grid")) {
     gp <- gpar(col="black", fill="yellow")
     rect <- pp_shape(label="rect")
     convex6 <- pp_shape(label="convex6")
     circle <- pp_shape(label="circle")

     pushViewport(viewport(x=0.25, y=0.75, width=1/2, height=1/2))
     grid.draw(rect$shape(gp=gp))
     grid.draw(rect$gridlines(gp=gpar(col="blue", lex=4)))
     grid.draw(rect$hexlines(gp=gpar(col="green")))
     popViewport()

     pushViewport(viewport(x=0.75, y=0.75, width=1/2, height=1/2))
     grid.draw(convex6$shape(gp=gp))
     grid.draw(convex6$checkers(gp=gpar(fill="blue")))
     popViewport()

     pushViewport(viewport(x=0.25, y=0.25, width=1/2, height=1/2))
     grid.draw(circle$shape(gp=gp))
     grid.draw(circle$mat(mat_width=0.2, gp=gpar(fill="blue")))
     popViewport()

     pushViewport(viewport(x=0.75, y=0.25, width=1/2, height=1/2))
     grid.draw(rect$shape(gp=gp))
     grid.draw(rect$mat(mat_width=c(0.2, 0.1, 0.3, 0.4), gp=gpar(fill="blue")))
     popViewport()

     grid.newpage()
     gp <- gpar(col="black", fill="yellow")

     vp <- viewport(x=1/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("halma")$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("pyramid")$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("kite")$shape(gp=gp, vp=vp))
     vp <- viewport(x=1/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("meeple")$shape(gp=gp, vp=vp))

     grid.newpage()
     vp <- viewport(x=1/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("convex3", 0)$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("convex4", 90)$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("convex5", 180)$shape(gp=gp, vp=vp))
     vp <- viewport(x=1/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("convex6", 270)$shape(gp=gp, vp=vp))

     grid.newpage()
     vp <- viewport(x=1/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("concave3", 0, 0.1)$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=1/4, width=1/2, height=1/2)
     grid.draw(pp_shape("concave4", 90, 0.2)$shape(gp=gp, vp=vp))
     vp <- viewport(x=3/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("concave5", 180, 0.3)$shape(gp=gp, vp=vp))
     vp <- viewport(x=1/4, y=3/4, width=1/2, height=1/2)
     grid.draw(pp_shape("concave6", 270)$shape(gp=gp, vp=vp))
 }
}
