% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rayrender.R
\name{piece}
\alias{piece}
\title{Create rayrender objects}
\usage{
piece(
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = pp_cfg(),
  x = 0,
  y = 0,
  z = NA,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  envir = NULL,
  ...,
  scale = 1,
  res = 72
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector of \code{pp_cfg} objects}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{axis_x}{Ignored for now.}

\item{axis_y}{Ignored for now.}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{...}{Ignored.}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{res}{Resolution of the faces.}
}
\value{
A rayrender object.
}
\description{
\code{piece} creates 3d board game piece objects for use with the rayrender package.
}
\examples{
  \donttest{
    if (require("rayrender")) {
        cfg <- pp_cfg()
        render_scene(piece("tile_face", suit = 3, rank = 3, cfg = cfg))
        render_scene(piece("coin_back", suit = 4, rank = 2, cfg = cfg))
        render_scene(piece("saucer_back", suit = 1, cfg = cfg))
        render_scene(piece("pawn_face", suit = 2, cfg = cfg))
    }
  }
}
