#' piecepackr: Board Game Graphics
#'
#' \if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}
#' Functions to make board game graphics.
#' Specializes in game diagrams, animations, and "Print & Play" layouts
#' for the 'piecepack' <https://www.ludism.org/ppwiki> but can make
#' graphics for other board game systems.
#' Includes configurations for several public domain game systems.
#' @section Package options:
#' The following piecepackr function arguments may be set globally via [base::options()]:
#'  \describe{
#'    \item{piecepack.at.inform}{If `FALSE` turns off messages when affine transformation support not detected in active graphics device.}
#'    \item{piecepackr.cfg}{Sets a new default for the `cfg` argument}
#'    \item{piecepackr.default.units}{Sets a new default for the `default.units` argument}
#'    \item{piecepackr.envir}{Sets a new default for the `envir` argument}
#'    \item{piecepackr.op_angle}{Sets a new default for the `op_angle` argument}
#'    \item{piecepackr.op_scale}{Sets a new default for the `op_scale` argument}
#'    \item{piecepackr.trans}{Sets a new default for the `trans` argument}
#'  }
#' @seealso Useful links:
#'
#'   * blog: \url{https://trevorldavis.com/piecepackr/}
#'   * pkgdown: \url{https://trevorldavis.com/R/piecepackr/}
#'   * forum: \url{https://groups.google.com/forum/#!forum/piecepackr}
#'   * Report bugs: \url{https://github.com/piecepackr/piecepackr/issues}
#'
#' @docType package
#' @name piecepackr-package
#' @aliases piecepackr-package piecepackr
NULL
