% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{SeqArc-class}
\alias{SeqArc-class}
\alias{SeqArc-method}
\alias{as.character,SeqArc-method}
\alias{show,SeqArc-method}
\alias{print,SeqArc-method}
\alias{str,SeqArc-method}
\alias{summary,SeqArc-method}
\alias{[[,SeqArc,character-method}
\alias{[,SeqArc,character,missing,missing-method}
\title{Sequence record archive}
\usage{
\S4method{as.character}{SeqArc}(x)

\S4method{show}{SeqArc}(object)

\S4method{print}{SeqArc}(x)

\S4method{str}{SeqArc}(object, max.level = 2L, ...)

\S4method{summary}{SeqArc}(object)

\S4method{[[}{SeqArc,character}(x, i)

\S4method{[}{SeqArc,character,missing,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{SeqArc} object}

\item{object}{\code{SeqArc} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}

\item{i}{sid(s)}

\item{j}{Unused}

\item{drop}{Unused}
}
\description{
Multiple sequence records containing sequence data.
}
\details{
Sequences are stored as raw. Use rawToChar().
}
\section{Slots}{

\describe{
\item{\code{ids}}{Vector of Sequence Record IDs}

\item{\code{nncltds}}{Vector of sequence lengths}

\item{\code{nambgs}}{Vector of number of ambiguous nucleotides}

\item{\code{txids}}{Vector source txid associated with each sequence}

\item{\code{sqs}}{List of SeqRecs named by ID}
}}

\examples{
data('aotus')
seqarc <- aotus@sqs
# this is a SeqArc object
# it contains sequence records
show(seqarc)
# you can access its different data slots with @
seqarc@ids     # sequence IDs defined as accession + feature position
seqarc@nncltds # number of nucleotides of all sequences  
seqarc@nambgs  # number of ambiguous nucleotides of all sequences
seqarc@txids   # all the taxonomic IDs for all sequences
seqarc@sqs     # list of all SeqRecs
# access sequence records [[
(seqarc[[seqarc@ids[[1]]]])  # first sequence record
# generate new sequence archives with [
(seqarc[seqarc@ids[1:10]])  # first 10 sequences
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqRec-class}},
  \code{\link{TaxDict-class}}, \code{\link{TaxRec-class}},
  \code{\link{clusters2_run}}, \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
