\name{bootstrap.seq}
\alias{bootstrap.seq}
\title{Bootstrap sequences from a fitted model and star tree.}
\description{
  This function bootstraps sequences from a model fitted by \code{phyclust}
  and star trees generated by \code{bootstrap.star.trees}.
  The fitted model can be varied in \code{.identifier}.
}
\usage{
bootstrap.seq(pcobj, star.trees)
}
\arguments{
  \item{pcobj}{a phyclust object in \code{Class phyclust}.}
  \item{star.trees}{star trees might be generated by \code{bootstrap.star.trees}.}
}
\details{
  \code{pcobj} is a phyclust object in \code{Class phyclust} which is usually
  fitted by \code{phyclust}, or returned by \code{phyclust.m.step}.

  \code{star.trees} should be corresponding to the \code{pcobj} which might
  be directly bootstraped from the function \code{bootstrap.star.trees}.
}
\value{
  Return a list containing sequences in \eqn{K}{K} clusters.
}
\references{
  Phylogenetic Clustering Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/phyclust/}
}
\author{
  Wei-Chen Chen \email{phyclust@gmail.com}
}
\seealso{
  \code{\link{phyclust}},
  \code{\link{bootstrap.star.trees}},
  \code{\link{bootstrap.star.trees.seq}}.
}
\examples{
\dontrun{
set.seed(1234)
EMC.1 <- .EMC
EMC.1$EM.iter <- 1
# the same as EMC.1 <- .EMControl(EM.iter = 1)

ret.1 <- phyclust(seq.data.toy$org, 2, EMC = EMC.1)
ret.tree <- bootstrap.star.trees(ret.1)
ret.seq <- bootstrap.seq(ret.1, ret.tree)
}
}
\keyword{programming}
