\name{data.phylip.crohn}
\alias{Data Crohn's Disease}
\docType{data}
\title{Crohn's disease SNP dataset in the phylip format}
\description{
  Crohn's disease dataset is published by Hugot, et al. (2001).
}
\format{
  A text file in phylip format is stored in the data subdirectory.
}
\details{
  Crohn's disease dataset is used to perform haplotype grouping used
  in Tzeng's paper (2005).

  Totally, 1102 haplotypes/SNP sequences and 8 sites.
}
\references{
  Phylogenetic Clustering Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/phyclust/}

  Hugot, J.P., et al. (2001)
  \dQuote{Association of NOD2 Leucine-Rich Repeat Variants with
          Susceptibility to Crohn's Disease},
  \emph{Nature}, \bold{411}, 599-603.

  Tzeng, J.Y. (2005)
  \dQuote{Evolutionary-Based Grouping of Haplotypes in Association Analysis},
  \emph{Genetics Epidemiology}, \bold{28}, 220-231.
  \url{http://www4.stat.ncsu.edu/~jytzeng/software.php}
}
\author{
  Hugot, J.P., et al. (2001).
}
\seealso{
  \code{\link{read.phylip.snp}}.
}
\examples{
\dontrun{
data.path <- paste(.libPaths()[1], "/phyclust/data/crohn.phy", sep = "")
# edit(file = data.path)
my.snp <- read.phylip.snp(data.path)
str(my.snp)
}
}
\keyword{datasets}
