% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_ngram_filter.R
\name{extract_ngram_filter}
\alias{extract_ngram_filter}
\title{Extract phrase spans}
\usage{
extract_ngram_filter(pos_tags, regex, maximum_ngram_length,
  minimum_ngram_length)
}
\arguments{
\item{pos_tags}{A character vector of Penn TreeBank or Petrov/Gimpel
style tags.}

\item{regex}{The regular expression used to find phrases.}

\item{maximum_ngram_length}{The maximum length phrases returned.}

\item{minimum_ngram_length}{The minimum length phrases returned.}
}
\value{
A numeric matrix with two columns and rows equal to number of spans
matched. First column is span start, second is span end.
}
\description{
Takes a sequences of POS tags and a regex and returns spans
which match regex.
}
\examples{
pos_tags <- c("VB", "JJ", "NN", "NN")
spans <- extract_ngram_filter(pos_tags,
                              regex = "(A|N)*N(PD*(A|N)*N)*",
                              maximum_ngram_length = 8,
                              minimum_ngram_length = 1)
}

