% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_SD.R
\name{add_SD}
\alias{add_SD}
\title{Add SD for a fixed parameter.}
\usage{
add_SD(fixed.parameters = NULL, parameters = NULL, SD = NULL)
}
\arguments{
\item{fixed.parameters}{Set of fixed parameters}

\item{parameters}{Set of current parameters}

\item{SD}{Standard deviation value to be added}
}
\value{
The parameters set with the new SD value
}
\description{
This function is used to add standard deviation for a fixed parameter.
}
\details{
add_SD adds SD for a fixed parameter.
}
\examples{
library(phenology)
# Generate a set of fixed parameter: Flat and Min
pfixed<-c(Flat=0, Min=0)
# Add SD for the Flat parameter
pfixed<-add_SD(fixed.parameters=pfixed, parameters="Flat", SD=5)
}
\author{
Marc Girondot
}
