% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.mcmcComposite}
\alias{plot.mcmcComposite}
\title{Plot the result of a MCMC search}
\usage{
\method{plot}{mcmcComposite}(x, ..., chain = 1, parameters = 1,
  scale.prior = FALSE, legend = TRUE)
}
\arguments{
\item{x}{A mcmcComposite object obtained after phenology_fonctionMCMC()}

\item{chain}{The chain to use}

\item{parameters}{Name of parameters or their number (see description)}

\item{legend}{If FALSE, the legend is not shown}

\item{scale.prior}{If TRUE, the prior is scaled at the same size as posterior}

\item{...}{Graphical parameters to be send to hist()}
}
\value{
None
}
\description{
Plot the result of a MCMC search.\cr
The parameters to use can be called by:\cr
parameters="all"\cr
parameters=1:4\cr
parameters=c("PAR1", "PAR2", "PAR5")\cr
parameters=c(TRUE, TRUE, FALSE, TRUE)\cr
}
\details{
plot.mcmcComposite plots the result of a MCMC search
}
\examples{
\dontrun{
library(phenology)
data(Gratiot)
# Generate a formatted list named data_Gratiot
data_Gratiot<-add_phenology(Gratiot, name="Complete",
    reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot,
		parametersfit=parg, parametersfixed=NULL, trace=1)
# Generate set of priors for Bayesian analysis
pmcmc <- phenology_MHmcmc_p(result_Gratiot, accept = TRUE)
result_Gratiot_mcmc <- phenology_MHmcmc(result = result_Gratiot, n.iter = 10000,
parametersMCMC = pmcmc, n.chains = 1, n.adapt = 0, thin = 1, trace = FALSE)
# Get standard error of parameters
summary(result_Gratiot_mcmc)
# Make diagnostics of the mcmc results using coda package
mcmc <- as.mcmc(result_Gratiot_mcmc)
require(coda)
heidel.diag(mcmc)
raftery.diag(mcmc)
autocorr.diag(mcmc)
acf(mcmc[[1]][,"LengthB"], lag.max=200, bty="n", las=1)
acf(mcmc[[1]][,"Max_Gratiot"], lag.max=50, bty="n", las=1)
batchSE(mcmc, batchSize=100)
# The batch standard error procedure is usually thought to
# be not as accurate as the time series methods used in summary
summary(mcmc)$statistics[,"Time-series SE"]
plot(result_Gratiot_mcmc, parameters=3, las=1, xlim=c(-10, 300))
}
}
\author{
Marc Girondot
}

