\name{print.phenology}
\alias{print.phenology}
\title{Print the result information from a result object.}
\usage{
  \method{print}{phenology} (x, ...)
}
\arguments{
  \item{x}{A result file generated by fit_phenology}

  \item{...}{Not used}
}
\value{
  None\cr
}
\description{
  The function print.phenology displays from a result.
}
\details{
  print.phenology prints the information from a result
  object.
}
\examples{
library(phenology)
# Read a file with data
\dontrun{
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
}
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
\dontrun{
result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
}
data(result_Gratiot)
# Show the result
result_Gratiot
}
\author{
  Marc Girondot
}

