% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wSG.R
\name{wSG}
\alias{wSG}
\title{Weighted Savitzky-Golay}
\usage{
wSG(y, w, nptperyear, ylu, wFUN = wTSM, iters = 2,
  frame = floor(nptperyear/7) * 2 + 1, d = 2, ...)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{nptperyear}{Integer, number of images per year.}

\item{ylu}{\code{[low, high]} of time-series y (curve fitting values are constrained
in the range of \code{ylu}.}

\item{wFUN}{weights updating function, can be one of 'wTSM', 'wChen' and
'wBisquare'.}

\item{iters}{How many times curve fitting is implemented.}

\item{frame}{Savitzky-Golay windows size}

\item{d}{polynomial of degree. When d = 1, it becomes moving average.}

\item{...}{Additional parameters are passed to \code{wFUN}.}
}
\value{
\itemize{
\item \code{ws}: weights of every iteration
\item \code{zs}: curve fittings of every iteration
}
}
\description{
Weighted Savitzky-Golay
}
\examples{
library(phenofit)
data("MOD13A1")
dt <- tidy_MOD13.gee(MOD13A1$dt)
d <- dt[site == "AT-Neu", ]

l <- check_input(d$t, d$y, d$w, nptperyear=23)
r_wSG <- wSG(l$y, l$w, l$ylu, nptperyear = 23, iters = 2)
}
\references{
\enumerate{
\item Chen, J., J"onsson, P., Tamura, M., Gu, Z., Matsushita, B., Eklundh, L.,
2004. A simple method for reconstructing a high-quality NDVI time-series
data set based on the Savitzky-Golay filter. Remote Sens. Environ. 91,
332-344. https://doi.org/10.1016/j.rse.2004.03.014. \cr
\item https://en.wikipedia.org/wiki/Savitzky%E2%80%93Golay_filter
}
}
