% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_train.R
\name{ph_train}
\alias{ph_train}
\title{Generate predictions for phenotype ensemble.}
\usage{
ph_train(
  train_df,
  vali_df,
  test_df,
  class_col,
  ctrl,
  train_seed = 123,
  n_cores = 2,
  task = "multi",
  methods = "all",
  metric = ifelse(task == "multi", "Kappa", "ROC"),
  tune_length = 10,
  quiet = FALSE
)
}
\arguments{
\item{train_df}{A \code{data.frame} containing a class column and the training data.}

\item{vali_df}{A \code{data.frame} containing a class column and the validation data.}

\item{test_df}{A \code{data.frame} containing a class column and the test d}

\item{class_col}{A \code{character} value for the name of the class column shared across the train, validation, and test sets.}

\item{ctrl}{A \code{list} containing the resampling strategy (e.g., "boot") and other parameters for \code{trainControl}. Automatically create one via \code{ph_ctrl} or manually create it with \code{trainControl}.}

\item{train_seed}{A \code{numeric} value to set the training seed and control the randomness of creating resamples: 123 (default).}

\item{n_cores}{An \code{integer} value for the number of cores to include in the cluster: 2 (default). We highly recommend increasing this value to, e.g., parallel::detectCores() - 1.}

\item{task}{A \code{character} value for the type of classification \code{task}: "multi" (default), "binary".}

\item{methods}{A \code{character} value enumerating the names (at least two, unless "all") of the classification methods to ensemble: "all" (default).
\itemize{
\item If \code{task = "binary"}, there are 33 methods to choose from: "AdaBag", "AdaBoost.M1", "C5.0", "evtree", "glmnet", "hda", "kernelpls", "kknn", "lda", "loclda", "mda", "nb", "nnet", "pda", "pls", "qda", "rda", "rf", "sparseLDA", "stepLDA", "stepQDA", "treebag", "svmLinear", "svmPoly","svmRadial", "gaussprLinear" (slow), "gaussprPoly" (slow), "gaussprRadial" (slow), "bagEarthGCV", "cforest", "earth", "fda", "hdda".
\item If \code{task = "multi"}, there are 30 methods to choose from:  "AdaBag", "AdaBoost.M1",  "C5.0", "evtree", "glmnet", "hda", "kernelpls", "kknn", "lda", "loclda", "mda", "nb", "nnet", "pda", "pls", "qda", "rda", "rf", "sparseLDA", "stepLDA", "stepQDA", "treebag", "svmLinear", "svmPoly", "svmRadial", "bagEarthGCV", "cforest", "earth", "fda", "hdda".
}}

\item{metric}{A \code{character} value for which summary metric should be used to select the optimal model: "ROC" (default for "binary") and "Kappa" (default for "multi"). Other options include "logLoss", "Accuracy", "Mean_Balanced_Accuracy", and "Mean_F1".}

\item{tune_length}{If \code{search = "random"} (default), this is an \code{integer} value for the maximum number of hyperparameter combinations to test for each training model in the ensemble; if \code{search = "grid"}, this is an \code{integer} value for the number of levels of each hyperparameter to test for each model.}

\item{quiet}{A \code{logical} value for whether progress should be printed: TRUE (default), FALSE.}
}
\value{
A list containing the following components:\tabular{ll}{
\code{train_models} \tab The \code{train} models for the ensemble. \cr
\tab \cr
\code{train_df} \tab The training data frame. \cr
\tab \cr
\code{vali_df} \tab The validation data frame. \cr
\tab \cr
\code{test_df} \tab The test data frame. \cr
\tab \cr
\code{task} \tab The type of classification task. \cr
\tab \cr
\code{ctrl} \tab A list of resampling parameters used in \code{trainControl}. \cr
\tab \cr
\code{methods} \tab The names of the classification methods to ensemble. \cr
\tab \cr
\code{search} \tab The hyperparameter search strategy. \cr
\tab \cr
\code{n_cores} \tab The number of cores for parallel processing. \cr
\tab \cr
\code{metric} \tab The summary metric used to select the optimal model. \cr
\tab \cr
\code{tune_length} \tab The maximum number of hyperparameter combinations ("random") or individual hyperparameter depth ("grid").  \cr
}
}
\description{
The \code{ph_train} function automatically trains a set of binary or multi-class classification models to ultimately
build a new dataset of predictions. The data preprocessing and hyperparameter tuning are handled internally to
minimize user input and simplify the training.
}
\examples{
## Import data.
data(ph_crocs)
\donttest{
## Remove anomalies with autoencoder.
rm_outs <- ph_anomaly(df = ph_crocs, ids_col = "Biosample",
                      class_col = "Species", method = "ae")
## Preprocess anomaly-free data frame into train, validation, and test sets
## with PCs as predictors.
pc_dfs <- ph_prep(df = rm_outs$df, ids_col = "Biosample",
                  class_col = "Species", vali_pct = 0.15,
                  test_pct = 0.15, method = "pca")
## Echo control object for train function.
ctrl <- ph_ctrl(ph_crocs$Species, resample_method = "boot")
## Train all models for ensemble.
## Note: Increasing n_cores will dramatically reduce train time.
train_models <- ph_train(train_df = pc_dfs$train_df,
                         vali_df = pc_dfs$vali_df,
                         test_df = pc_dfs$test_df,
                         class_col = "Species",
                         ctrl = ctrl,
                         task = "multi",
                         methods = "all",
                         tune_length = 5,
                         quiet = FALSE)
## You can also train just a few, although more is preferable.
## Note: Increasing n_cores will dramatically reduce train time.
train_models <- ph_train(train_df = pc_dfs$train_df,
                         vali_df = pc_dfs$vali_df,
                         test_df = pc_dfs$test_df,
                         class_col = "Species",
                         ctrl = ctrl,
                         task = "multi",
                         methods = c("lda", "mda",
                         "nnet", "pda", "sparseLDA"),
                         tune_length = 5,
                         quiet = FALSE)
}
}
