% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{unfix_parameters_to}
\alias{unfix_parameters_to}
\title{unfix_parameters_to}
\usage{
unfix_parameters_to(model, inits)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{inits}{(list(str=numeric)) Inits for all parameters to unfix and change init}
}
\value{
(Model) Pharmpy model object
}
\description{
Unfix parameters to

Unfix all listed parameters to specified value/values
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- fix_parameters(model, c('POP_CL', 'POP_VC'))
model$parameters$fix
model <- unfix_parameters_to(model, {'POP_CL': 0.5})
model$parameters$fix
model$parameters['POP_CL']
}
}
\seealso{
fix_parameters : Fix parameters

fix_or_unfix_parameters : Fix or unfix parameters (given boolean)

unfix_paramaters : Unfixing parameters

fix_paramaters_to : Fixing parameters and setting a new initial estimate in the same

function
}
