% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{create_basic_pk_model}
\alias{create_basic_pk_model}
\title{create_basic_pk_model}
\usage{
create_basic_pk_model(
  administration = "iv",
  dataset_path = NULL,
  cl_init = 0.01,
  vc_init = 1,
  mat_init = 0.1
)
}
\arguments{
\item{administration}{(str) Type of PK model to create. Supported are 'iv', 'oral' and 'ivoral'}

\item{dataset_path}{(str (optional)) Optional path to a dataset}

\item{cl_init}{(numeric) Initial estimate of the clearance parameter}

\item{vc_init}{(numeric) Initial estimate of the central volume parameter}

\item{mat_init}{(numeric) Initial estimate of the mean absorption time parameter (if applicable)}
}
\value{
(Model) Pharmpy model object
}
\description{
Creates a basic pk model of given type. The model will be a one compartment model, with first
order elimination and in the case of oral administration first order absorption with no absorption
delay. The elimination rate will be (equation could not be rendered, see API doc on website)
}
\examples{
\dontrun{
model <- create_basic_pk_model('oral')
}

}
