% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{summarize_modelfit_results}
\alias{summarize_modelfit_results}
\title{summarize_modelfit_results}
\usage{
summarize_modelfit_results(models, include_all_estimation_steps = FALSE)
}
\arguments{
\item{models}{(vector, Model) List of models or single model}

\item{include_all_estimation_steps}{(logical) Whether to include all estimation steps, default is FALSE}
}
\value{
(data.frame) A DataFrame of modelfit results with model name and estmation step as index.
}
\description{
Summarize results of model runs

Summarize different results after fitting a model, includes runtime, ofv,
and parameter estimates (with errors). If include_all_estimation_steps is FALSE,
only the last estimation step will be included (note that in that case, the
minimization_successful value will be referring to the last estimation step, if
last step is evaluation it will go backwards until it finds an estimation step
that wasn't an evaluation).
}
\examples{
\dontrun{
model <- load_example_model("pheno")
summarize_modelfit_results(model)
}

}
