% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_allometry}
\alias{run_allometry}
\title{run_allometry}
\usage{
run_allometry(
  model = NULL,
  allometric_variable = "WT",
  reference_value = 70,
  parameters = NULL,
  initials = NULL,
  lower_bounds = NULL,
  upper_bounds = NULL,
  fixed = TRUE
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{allometric_variable}{(str) Name of the variable to use for allometric scaling (default is WT)}

\item{reference_value}{(numeric) Reference value for the allometric variable (default is 70)}

\item{parameters}{(vector) Parameters to apply scaling to (default is all CL, Q and V parameters)}

\item{initials}{(vector) Initial estimates for the exponents. (default is to use 0.75 for CL and Qs and 1 for Vs)}

\item{lower_bounds}{(vector) Lower bounds for the exponents. (default is 0 for all parameters)}

\item{upper_bounds}{(vector) Upper bounds for the exponents. (default is 2 for all parameters)}

\item{fixed}{(logical) Should the exponents be fixed or not. (default TRUE)}
}
\value{
(AllometryResults) Allometry tool result object
}
\description{
Run allometry tool. For more details, see :ref:\code{allometry}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
run_allometry(model=model, allometric_variable='WGT')
}

}
