% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{rank_models}
\alias{rank_models}
\title{rank_models}
\usage{
rank_models(
  base_model,
  models,
  strictness = NULL,
  rank_type = "ofv",
  cutoff = NULL,
  bic_type = "mixed"
)
}
\arguments{
\item{base_model}{(Model) Base model to compare to}

\item{models}{(vector) List of models}

\item{strictness}{(vector or NULL) List of strictness criteria to be fulfilled, currently only minimization successful.
Default is NULL}

\item{rank_type}{(str) Name of ranking type. Available options are 'ofv', 'aic', 'bic', 'lrt' (OFV with LRT)}

\item{cutoff}{(numeric or NULL) Value to use as cutoff. If using LRT, cutoff denotes p-value. Default is NULL}

\item{bic_type}{(str) Type of BIC to calculate. Default is the mixed effects.}
}
\value{
((data.frame, vector)) A tuple with a DataFrame of the ranked models and a vector of ranked models sorted by rank
}
\description{
Ranks a vector of models

Ranks a vector of models with a given ranking function
}
\examples{
\dontrun{
model_1 <- load_example_model("pheno")
model_2 <- load_example_model("pheno_linear")
rank_models(model_1, c(model_2),
            strictness=c('minimization_successful'),
            rank_type='lrt')
}

}
