% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-footer.R
\name{add_titles}
\alias{add_titles}
\alias{add_footnotes}
\title{Add \code{hf_line} title(s) and footnote(s) to a \code{rtf_doc} object}
\usage{
add_titles(doc, ..., replace = FALSE)

add_footnotes(doc, ..., replace = FALSE)
}
\arguments{
\item{doc}{\code{rtf_doc} on which hf_line object(s) (i.e. titles/footnotes)
will be attached}

\item{...}{A vector of \code{hf_line} objects to add passed to
\code{add_hf()}}

\item{replace}{If FALSE, lines will be appended/ordered with current
header/footer lines. If TRUE, lines will replace the existing content.}
}
\value{
\code{hf_line} object(s) (i.e. titles/footnotes) to be added
}
\description{
Add \code{hf_line} titles/footnote objects to a \code{rtf_doc} object
}
\examples{
# Adding titles after rtf_doc construction
ht <- huxtable::huxtable(
 column1 = 1:5,
 column2 = letters[1:5]
)
rtf <- rtf_doc(ht)

rtf <- add_titles(rtf, hf_line("The Title"))

# Adding footnotes after rtf_doc construction
ht <- huxtable::huxtable(
 column1 = 1:5,
 column2 = letters[1:5]
)
rtf <- rtf_doc(ht)

rtf <- add_footnotes(rtf, hf_line("The Footnote"))

}
