/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.fonts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidFont;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontManager
extends PSObjectDict {
    private static boolean alreadyInitialized = false;
    private static final PSObjectName DEFAULT_FONT = new PSObjectName("Times-Roman", true);
    private static Properties fontSubstitutions;
    private static Map<String, Properties> allTexStrings;
    private static final Logger LOG;
    public static final String AFM_DIR_NAME = "afm";
    public static final String FONTDESC_DIR_NAME = "fontdescriptions";
    private static final String TEXSTRINGS_DIR_NAME = "texstrings";
    private static final String TEXSTRINGS_REGEXP = "eps2pgf_select_regexp";
    private static final String TEXSTRINGS_ORDER = "eps2pgf_select_order";
    public static final PSObjectName FONT_DICT_KEY;

    public FontManager() throws ProgramError {
        FontManager.initialize();
        try {
            this.readonly();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
    }

    public static void initialize() throws ProgramError {
        if (!alreadyInitialized) {
            fontSubstitutions = FontManager.loadFontSubstitutions(new File(Utils.getResourceDir(), "fontSubstitution.xml"));
            allTexStrings = FontManager.loadAllTexstrings();
            alreadyInitialized = true;
        }
    }

    public PSObjectFont defineFont(PSObject pSObject, PSObjectFont pSObjectFont) throws PSError, ProgramError {
        pSObjectFont.setFID();
        pSObjectFont.toDict().setKey((PSObject)FONT_DICT_KEY, pSObject);
        try {
            pSObjectFont.assertValidFont();
        }
        catch (PSErrorUnimplemented pSErrorUnimplemented) {
            // empty catch block
        }
        this.setKey(pSObject, (PSObject)pSObjectFont);
        return pSObjectFont;
    }

    public PSObjectFont findFont(PSObject pSObject) throws ProgramError, PSError {
        PSObject pSObject2 = pSObject;
        PSObject pSObject3 = FontManager.findSubstitutionFont(pSObject2);
        if (pSObject3 != null) {
            LOG.info("Substituting font " + pSObject3 + " for " + pSObject2);
            pSObject2 = pSObject3;
        }
        try {
            PSObject pSObject4 = this.get(pSObject2);
            if (!(pSObject4 instanceof PSObjectFont)) {
                throw new ProgramError("Non PSObjectFont object found in FontDirectory");
            }
            return (PSObjectFont)pSObject4;
        }
        catch (PSErrorUndefined pSErrorUndefined) {
            try {
                return this.loadFont(pSObject2);
            }
            catch (PSErrorInvalidFont pSErrorInvalidFont) {
                if (pSObject2.equals(DEFAULT_FONT)) {
                    throw new ProgramError("Unable to load " + DEFAULT_FONT + " font.");
                }
                LOG.info("Unable to find this font. Substituting font " + DEFAULT_FONT + " for " + pSObject2 + ".");
                return this.findFont(DEFAULT_FONT);
            }
        }
    }

    private static PSObject findSubstitutionFont(PSObject pSObject) {
        String string = pSObject instanceof PSObjectName || pSObject instanceof PSObjectString ? pSObject.toString() : pSObject.isis();
        String string2 = fontSubstitutions.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return new PSObjectName(string2, true);
    }

    private PSObjectFont loadFont(PSObject pSObject) throws PSError, ProgramError {
        String string = pSObject.toString();
        LOG.info("Loading " + string + " font from " + Utils.getResourceDir());
        PSObjectFont pSObjectFont = new PSObjectFont(Utils.getResourceDir(), string);
        this.defineFont(pSObject, pSObjectFont);
        return pSObjectFont;
    }

    private static Properties loadFontSubstitutions(File file) {
        Properties properties;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.loadFromXML(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return properties;
    }

    private static Map<String, Properties> loadAllTexstrings() throws ProgramError {
        File file = new File(Utils.getResourceDir(), TEXSTRINGS_DIR_NAME);
        File[] fileArray = file.listFiles();
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        for (int i = 0; i < fileArray.length; ++i) {
            Properties properties;
            Object object;
            try {
                object = new FileInputStream(fileArray[i]);
                properties = new Properties();
                properties.loadFromXML((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                continue;
            }
            object = fileArray[i].getName();
            if (((String)object).endsWith(".xml")) {
                object = ((String)object).substring(0, ((String)object).length() - 4);
            }
            hashMap.put((String)object, properties);
        }
        return hashMap;
    }

    public static PSObjectDict getTexStringDict(String string) {
        Properties properties = allTexStrings.get(string);
        PSObjectDict pSObjectDict = new PSObjectDict();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (string2.startsWith("eps2pgf")) continue;
            pSObjectDict.setKey(string2, properties.getProperty(string2));
        }
        return pSObjectDict;
    }

    public static PSObjectDict getTexStringDictByFontname(String string) {
        String string2 = "default";
        int n = Integer.MAX_VALUE;
        for (String string3 : allTexStrings.keySet()) {
            String string4;
            Properties properties = allTexStrings.get(string3);
            String string5 = properties.getProperty(TEXSTRINGS_ORDER, "999999");
            int n2 = Integer.parseInt(string5);
            if (n2 > n || !string.matches(string4 = properties.getProperty(TEXSTRINGS_REGEXP, "^$"))) continue;
            string2 = string3;
            n = n2;
        }
        return FontManager.getTexStringDict(string2);
    }

    public boolean fontTypeStatus(PSObject pSObject) throws PSError {
        String string = String.format("net.sf.eps2pgf.ps.resources.fonts.Type%d", pSObject.toInt());
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        LOG = Logger.getLogger("net.sourceforge.eps2pgf");
        FONT_DICT_KEY = new PSObjectName("/FontDirectoryKey");
    }
}

