/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.PSStringInputStream;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.Parser;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectReal;
import net.sf.eps2pgf.ps.objects.PSObjectString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSObjectArray
extends PSObject {
    private List<PSObject> array;
    private int offset;
    private int count;

    public PSObjectArray() {
        this.setArray(new ArrayList<PSObject>());
        this.setOffset(0);
        this.setCount(Integer.MAX_VALUE);
    }

    public PSObjectArray(double[] dArray) {
        this.setArray(new ArrayList<PSObject>(dArray.length));
        for (int i = 0; i < dArray.length; ++i) {
            this.getArray().add(new PSObjectReal(dArray[i]));
        }
        this.setOffset(0);
        this.setCount(dArray.length);
    }

    public PSObjectArray(PSObject[] pSObjectArray) {
        this.setArray(new ArrayList<PSObject>(pSObjectArray.length));
        for (int i = 0; i < pSObjectArray.length; ++i) {
            this.getArray().add(pSObjectArray[i]);
        }
        this.setOffset(0);
        this.setCount(pSObjectArray.length);
    }

    public PSObjectArray(String string) throws ProgramError, PSError {
        String string2 = string;
        if (string2.charAt(0) == '{') {
            this.setLiteral(false);
        } else if (string2.charAt(0) == '[') {
            this.setLiteral(true);
        }
        string2 = string2.substring(1, string2.length() - 1);
        PSStringInputStream pSStringInputStream = new PSStringInputStream(new PSObjectString(string2));
        try {
            this.setArray(Parser.convertAll(pSStringInputStream));
            this.setCount(this.getArray().size());
            this.setOffset(0);
        }
        catch (IOException iOException) {
            throw new ProgramError("An IOException occured in PSObjectArray(String)");
        }
    }

    public PSObjectArray(PSObjectArray pSObjectArray, int n, int n2) throws PSErrorRangeCheck {
        int n3 = pSObjectArray.size();
        if (n2 != 0 || n != 0) {
            if (n >= n3) {
                throw new PSErrorRangeCheck();
            }
            if (n + this.getCount() - 1 >= n3) {
                throw new PSErrorRangeCheck();
            }
        }
        this.setArray(pSObjectArray.getArray());
        this.setOffset(pSObjectArray.getOffset() + n);
        this.setCount(n2);
        this.copyCommonAttributes(pSObjectArray);
    }

    public final void addAt(int n, PSObject pSObject) {
        this.getArray().add(n + this.getOffset(), pSObject);
    }

    public final void addToEnd(PSObject pSObject) {
        this.getArray().add(pSObject);
    }

    @Override
    public final PSObjectArray bind(Interpreter interpreter) throws PSErrorTypeCheck {
        try {
            for (int i = 0; i < this.size(); ++i) {
                PSObject pSObject = this.get(i);
                this.set(i, pSObject.bind(interpreter));
                if (!(pSObject instanceof PSObjectArray) || ((PSObjectArray)pSObject).isLiteral()) continue;
                pSObject.readonly();
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        return this;
    }

    @Override
    public PSObjectArray clone() {
        PSObjectArray pSObjectArray = (PSObjectArray)super.clone();
        pSObjectArray.setArray(new ArrayList<PSObject>(this.getArray().size()));
        for (PSObject pSObject : this.getArray()) {
            pSObjectArray.getArray().add(pSObject.clone());
        }
        return pSObjectArray;
    }

    @Override
    public final PSObject copy(PSObject pSObject) throws PSErrorRangeCheck, PSErrorTypeCheck {
        PSObjectArray pSObjectArray = pSObject.toArray();
        this.putinterval(0, pSObjectArray);
        return this.getinterval(0, pSObjectArray.length());
    }

    @Override
    public PSObjectArray dup() {
        try {
            return new PSObjectArray(this, 0, this.size());
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
    }

    @Override
    public boolean eq(PSObject pSObject) {
        try {
            PSObjectArray pSObjectArray = pSObject.toArray();
            if (this.getCount() != pSObjectArray.getCount() || this.getOffset() != pSObjectArray.getOffset()) {
                return false;
            }
            return this.getArray() == pSObjectArray.getArray();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            return false;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getArray()).hashCode() + this.getOffset();
    }

    public PSObject get(int n) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.size()) {
            throw new PSErrorRangeCheck();
        }
        return this.getArray().get(n + this.getOffset());
    }

    @Override
    public PSObject get(PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck, PSErrorUndefined {
        return this.get(pSObject.toInt());
    }

    @Override
    public List<PSObject> getItemList() {
        LinkedList<PSObject> linkedList = new LinkedList<PSObject>();
        linkedList.add(new PSObjectInt(1));
        for (PSObject pSObject : this) {
            linkedList.add(pSObject);
        }
        return linkedList;
    }

    @Override
    public PSObjectArray getinterval(int n, int n2) throws PSErrorRangeCheck {
        return new PSObjectArray(this, n, n2);
    }

    public double getReal(int n) throws PSErrorRangeCheck, PSErrorTypeCheck {
        return this.get(n).toReal();
    }

    public static boolean isType(String string) {
        int n = string.length();
        if (string.charAt(0) == '{' && string.charAt(n - 1) == '}') {
            return true;
        }
        return string.charAt(0) == '[' && string.charAt(n - 1) == ']';
    }

    @Override
    public String isis() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLiteral()) {
            stringBuilder.append("[ ");
        } else {
            stringBuilder.append("{ ");
        }
        for (PSObject pSObject : this) {
            stringBuilder.append(pSObject.isis() + " ");
        }
        if (this.isLiteral()) {
            stringBuilder.append("]");
        } else {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public void put(PSObject pSObject, PSObject pSObject2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.put(pSObject.toInt(), pSObject2);
    }

    public void put(int n, PSObject pSObject) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.size()) {
            throw new PSErrorRangeCheck();
        }
        this.getArray().set(n + this.getOffset(), pSObject);
    }

    @Override
    public void putinterval(int n, PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck {
        PSObjectArray pSObjectArray = pSObject.toArray();
        int n2 = pSObjectArray.length();
        for (int i = 0; i < n2; ++i) {
            this.set(n + i, pSObjectArray.get(i));
        }
    }

    public PSObject remove(int n) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.size()) {
            throw new PSErrorRangeCheck();
        }
        return this.getArray().remove(n + this.getOffset());
    }

    public void set(int n, PSObject pSObject) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.size()) {
            throw new PSErrorRangeCheck();
        }
        this.getArray().set(n + this.getOffset(), pSObject);
    }

    public void setReal(int n, double d) throws PSErrorRangeCheck {
        this.set(n, new PSObjectReal(d));
    }

    public int size() {
        return Math.min(this.getCount(), this.getArray().size() - this.getOffset());
    }

    @Override
    public PSObjectArray toArray() {
        return this;
    }

    public double[] toDoubleArray(int n) throws PSErrorRangeCheck, PSErrorTypeCheck {
        if (n != this.size()) {
            throw new PSErrorRangeCheck();
        }
        return this.toDoubleArray();
    }

    public double[] toDoubleArray() throws PSErrorTypeCheck {
        double[] dArray = new double[this.size()];
        try {
            for (int i = 0; i < this.size(); ++i) {
                dArray[i] = this.get(i).toReal();
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        return dArray;
    }

    @Override
    public PSObjectMatrix toMatrix() throws PSErrorRangeCheck, PSErrorTypeCheck {
        return new PSObjectMatrix(this);
    }

    @Override
    public PSObjectArray toProc() throws PSErrorTypeCheck {
        if (this.isLiteral()) {
            throw new PSErrorTypeCheck();
        }
        return this;
    }

    @Override
    public List<PSObject> token() throws PSError {
        ArrayList<PSObject> arrayList;
        int n = this.size();
        if (n == 0) {
            arrayList = new ArrayList<PSObject>(1);
            arrayList.add(0, new PSObjectBool(false));
        } else {
            arrayList = new ArrayList(3);
            if (n == 1) {
                arrayList.add(0, new PSObjectArray());
            } else {
                arrayList.add(0, new PSObjectArray(this, 1, n - 1));
            }
            arrayList.add(1, this.get(0));
            arrayList.add(2, new PSObjectBool(true));
        }
        return arrayList;
    }

    @Override
    public String type() {
        return "arraytype";
    }

    void setCount(int n) {
        this.count = n;
    }

    int getCount() {
        return this.count;
    }

    void setOffset(int n) {
        this.offset = n;
    }

    int getOffset() {
        return this.offset;
    }

    void setArray(List<PSObject> list) {
        this.array = list;
    }

    List<PSObject> getArray() {
        return this.array;
    }
}

