# ----------------------------------------
# --      PROGRAM server_global.R       --
# ----------------------------------------
# USE: Server-specific variables and
#      functions for the main reactive
#      shiny server functionality.  All
#      code in this file will be put into
#      the framework outside the call to
#      shinyServer(function(input, output, session)
#      in server.R
#
# NOTEs:
#   - All variables/functions here are
#     SERVER scoped and are available
#     across all user sessions, but not to
#     the UI.
#
#   - For user session-scoped items
#     put var/fxns in server_local.R
#
# FRAMEWORK VARIABLES
#     none
# ----------------------------------------

# -- IMPORTS --


# -- VARIABLES --
node_event <- JS("{'mousemove':function(o, e, t) {
                                   if (o != null &&
                                       o != false &&
                                       o.objectType == 'Tree') {
                                       Shiny.setInputValue('node_name', o.display, {priority: 'event'});
                                   }
                               }}")
node_description <- list("global.R"             = "Handles FRAMEWORK global work, do not edit this file",
                         "server.R"             = "Handles FRAMEWORK server work, do not edit this file",
                         "ui.R"                 = "Handles FRAMEWORK UI work",
                         "log"                  = "Stores application log files",
                         "actions.log"          = "Application logs",
                         "actions.log.last"     = "Application logs history",
                         "program"              = "All logic goes here",
                         "config"               = "Where user can store application configuration files",
                         "announce.yaml"        = "Announcement module configuration file",
                         "data"                 = "Where user can sotre related data files (rds, csv, ...)",
                         ".gitignore"           = "Keep files extenstions to be ignored by Git",
                         "fxns"                 = "Where application spcialzed logic goes (plot helers, data helpers, ...)",
                         "modules"              = "Application modules",
                         "program.global.R"     = "All variables or/and functions that should be globally scoped to server, UI and session scopes should be here",
                         "server_global.R"      = "All variables or/and functions that should be SERVER scoped and are available across all user sessions, but not to UI, should be here",
                         "server_local.R"       = "All variables or/and functions here are SESSION scoped and are ONLY available to a single session and not to the UI",
                         "ui_body.R"            = "Application body UI goes here",
                         "ui_footer.R"          = "Application footer UI goes here",
                         "ui_header.R"          = "Application header UI goes here",
                         "ui_left_sidebar.R"    = "Application left sidebar UI goes here",
                         "ui_right_sidebar.R"   = "Application right sidebar UI goes here",
                         "www"                  = "store client side related code (js, css, icons, ..)",
                         "periscope_style.yaml" = "Application theme variables (i.e primary colors, sidebar width, ...)",
                         "css"                  = "Store application css files",
                         "custom.css"           = "Application main css file",
                         "js"                   = "Store application js files",
                         "custom.js"            = "Application main js file",
                         "img"                  = "Application related images and icons",
                         "loader.gif"           = "buys indicator used image",
                         "tooltip.png"          = "Tooltips used image",
                         "App_Root"             = "Appication main root")
# -- FUNCTIONS --


