% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_HapMat.R
\name{createHapMat}
\alias{createHapMat}
\title{Create an object of class \code{hapMat}}
\usage{
createHapMat(hapmat, snvNames, hapNames, posns)
}
\arguments{
\item{hapmat}{A matrix of 0's and 1's, with rows representing haplotypes and columns representing 
single-nucleotide variants (SNVs).}

\item{snvNames}{A vector of names of SNVs for the columns of \code{hapmat}.}

\item{hapNames}{A vector of names of haplotypes for the rows of \code{hapmat}.}

\item{posns}{A numeric vector specifying the genomic positions (e.g. in base pairs) of SNVs in the
columns of \code{hapmat}.}
}
\value{
An object of class \code{hapMat}.
}
\description{
This function creates a \code{hapMat} data object, a required input for \code{\link{reconstructPP}}.
}
\examples{
hapmat = matrix(c(1,1,1,0,
                  0,0,0,0,
                  1,1,1,1,
                  1,0,0,0,
                  1,1,0,0,
                  1,0,0,1,
                  1,0,0,1), byrow = TRUE, ncol = 4)
snvnames = c(paste("SNV", 1:4, sep = ""))
allhaps = c("h1", "h2", "h3", "h4", "h5", "h6", "h7")
# Physical positions
posns = c(1000, 2000, 3000, 4000)

# Create hapMat data object
ex_hapMat <- createHapMat(hapmat = hapmat,
                               snvNames = snvnames,
                               hapNames = allhaps,
                               posns = posns)


}
