% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dend.R
\name{plotDend}
\alias{plotDend}
\title{Plot reconstructed dendrogram}
\usage{
plotDend(dend, direction = "downwards")
}
\arguments{
\item{dend}{An object of class \code{phylo} or of class \code{multiPhylo} returned from
\code{reconstructPP} or \code{reconsPPregion}.}

\item{direction}{A character string specifying the direction of the dendrogram. Four values are
possible: "downwards" (the default),  "upwards", "leftwards" and "rightwards".}
}
\description{
This function plots reconstructed dendrogram in a genomic region.
}
\examples{

data(ex_hapMat_data)

ex_dend <- reconstructPP(hapMat = ex_hapMat_data,
                         focalSNV = 3,
                         minWindow = 1,
                         sep = "-")

plotDend(dend = ex_dend, direction = "downwards")

}
