% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap Lasso Implementation (in development)}
\usage{
bootstrap(
  data,
  dep,
  indep = NULL,
  cluster_id = NULL,
  fixed = NULL,
  selectobs = NULL,
  bootreps = 250,
  boot_threshold = 0.01,
  colcheck_x = FALSE,
  colcheck_x_fes = FALSE,
  post = FALSE,
  gamma_val = NULL,
  verbose = FALSE,
  tol = 1e-06,
  hdfetol = 0.01,
  penweights = NULL,
  maxiter = 1000,
  ...
)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the names of the independent variables or their column numbers.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{cluster_id}{A string denoting the cluster-id with which to perform
cluster bootstrap.}

\item{fixed}{A vector with the names or column numbers of factor variables identifying the fixed effects,
or a list with the desired interactions between variables in \code{data}.}

\item{selectobs}{Optional. A vector indicating which observations to use (either a logical vector
or a numeric vector with row numbers, as usual when subsetting in R).}

\item{bootreps}{Number of bootstrap repetitions.}

\item{boot_threshold}{Minimal threshold. If a variable is selected in at least this
fraction of times, it is reported at the end of the iterations.}

\item{colcheck_x}{Logical. If \code{TRUE}, this checks collinearity between the independent variables and drops the
collinear variables.}

\item{colcheck_x_fes}{Logical. If \code{TRUE}, this checks whether the independent variables are perfectly explained
by the fixed effects drops those that are perfectly explained.}

\item{post}{Logical. If \code{TRUE}, estimates a post-penalty regression with the selected variables.}

\item{gamma_val}{Numerical value that determines the regularization threshold as defined in Belloni, Chernozhukov, Hansen, and Kozbur (2016). NULL default sets parameter to 0.1/log(n).}

\item{verbose}{Logical. If \code{TRUE}, it prints information to the screen while evaluating.}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{hdfetol}{Tolerance parameter for the within-transformation step,
passed on to \code{collapse::fhdwithin}.}

\item{penweights}{Optional: a vector of coefficient-specific penalties to use in plugin lasso when
\code{method == "plugin"}.}

\item{maxiter}{Maximum number of iterations (a number).}

\item{...}{Further arguments, including:
\itemize{
\item \code{tol}: Tolerance parameter for convergence of the IRLS algorithm.
\item \code{hdfetol}: Tolerance parameter for the within-transformation step, passed on to \code{collapse::fhdwithin}.
\item \code{penweights}: Optional: a vector of coefficient-specific penalties to use in plugin lasso.
\item \code{colcheck_x}: Logical. If \code{TRUE}, checks for perfect multicollinearity in \code{x}.
\item \code{colcheck_x_fes}: Logical. If \code{TRUE}, checks whether \code{x} is perfectly explained by \code{fes}.
\item \code{maxiter}: Maximum number of iterations in hdfeppml used to get first guess of mu.
\item \code{verbose}: Logical. If \code{TRUE}, prints information to the screen while evaluating.
\item \code{post}: Logical. If \code{TRUE}, it carries out a post-lasso estimation with just the
selected variables and reports the coefficients from this regression.
}}
}
\value{
A matrix with coefficient estimates for all dependent variables.
}
\description{
This function performs standard plugin lasso PPML estimation for \code{bootreps} samples drawn again with
replacement and reports
those regressors selected in at least a certain fraction of the bootstrap repetitions.
}
\details{
This function enables users to implement the "bootstrap" step in the procedure described in
Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2020). To do this, Plugin Lasso is run B times.
The function can also perform a post-selection estimation.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
\dontrun{bs1 <- bootstrap(data=trade3, dep="export",
                 cluster_id="clus",
                 fixed=list(c("exp", "time"),
                 c("imp", "time"), c("exp", "imp")),
                 indep=7:22, bootreps=10, colcheck_x = TRUE,
                 colcheck_x_fes = TRUE,
                 boot_threshold = 0.01,
                 post=TRUE, gamma_val=0.01, verbose=FALSE)}

}
