% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_stan.R
\name{as.stan}
\alias{as.stan}
\title{Convert an object to stanfit}
\usage{
as.stan(x, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{stanfit}, as documented in \link[rstan:stan]{rstan::stan}.
}
\description{
Create a \code{stanfit} object from an object for which a method exists,
so that all methods for \code{stanfit} objects can be used.
}
\examples{
stanfit <- "a"
class(stanfit) <- "stanfit"
brmaobject <- list(fit = stanfit)
class(brmaobject) <- "brma"
converted <- as.stan(brmaobject)
}
