% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/numint.R
\name{is.numint}
\alias{is.all.factor}
\alias{is.all.integer}
\alias{is.all.numeric}
\alias{is.all.numint}
\alias{is.any.factor}
\alias{is.numint}
\alias{is.one.type}
\title{Tests for data types}
\usage{
is.numint(x)

is.all.numint(x)

is.all.integer(x)

is.all.factor(x)

is.any.factor(x)

is.all.numeric(x)

is.one.type(x)
}
\arguments{
\item{x}{Object to be tested.}
}
\value{
\code{TRUE} or \code{FALSE} depending on whether \code{x} contains a given
data type.
}
\description{
Evaluate the data type contained in an object.
}
\examples{
# Vector of integers
x <- 1:10
is.numint(x) # FALSE
# Vector of numeric integers
x <- as.numeric(x)
is.numint(x) # TRUE
# Vector of numeric values
x <- c(1.1, 1, 1, 1, 2) # FALSE
is.numint(x)
# Single numeric integer
is.numint(1) # TRUE
# Single numeric value
is.numint(1.1) # FALSE
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\seealso{
\code{\link[base]{is.numeric}}, \code{\link[base]{is.integer}},
\code{\link[base]{is.factor}}.
}

