\name{ps_ouss_asymptotic}
\alias{ps_ouss_asymptotic}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Power spectrum of the OUSS process
}
\description{
Returns the power spectrum of the Ornstein-Uhlenbeck state space (OUSS) process at a particular frequency. This is the asymptotic expected periodogram power for long regular time series.
}
\usage{
ps_ouss_asymptotic(freq, power_o, sigma, 
                   rho, lambda, 
                   power_e, epsilon, time_step)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{freq}{
    Single number or numeric vector. The frequency for which to the power spectrum is to be calculated.
}
  \item{power_o}{
    Single non-negative number. Power spectrum at zero-frequency generated by the underlying OU process, when sampled at the given \code{time_step}. Either \code{power_o} or \code{sigma} (but not both) must be provided.
}
  \item{sigma}{
    Single number. Standard deviation of OU fluctuations around equilibrium. Either \code{power_o} or \code{sigma} (but not both) must be provided.
  }
    \item{rho}{
    Single number between 0 (exclusive) and 1 (inclusive). Correlation of the OU process between two subsequent time points. Either \code{rho} or \code{lambda} (but not both) must be provided.
}
  \item{lambda}{
    Single non-negative number. Resilience (or relaxation rate) of the OU process. This is also the inverse correlation time of the OU process. Either \code{rho} or \code{lambda} (but not both) must be provided. 
}
  \item{power_e}{
    Single non-negative number. Asymptotic power spectrum at large frequencies due to the random measurement errors. Setting this to zero corresponds to the classical OU process. Either \code{power_e} or \code{epsilon} (but not both) must be provided.
}
  \item{epsilon}{
    Single number. Standard deviation of Gaussian measurement error. Setting this to zero corresponds to the classical OU process. Either \code{power_e} or \code{epsilon} (but not both) must be provided.
  }
  \item{time_step}{
    Positive number. The time step of the time series that was (or will be) used for periodogram generation.
}
}
\details{
The OUSS parameters \code{power_o}, \code{lambda} and \code{power_e} will typically be maximum-likelihood fitted values returned by \code{\link{evaluate.pm}}. \code{time_step} is also returned by \code{\link{evaluate.pm}} and is inferred from the analysed time series. More generally, \code{power_o} and \code{power_e} are proportional to the OUSS parameters \code{sigma^2} and \code{epsilon^2} (see \code{\link{generate_ouss}}), respectively, but the exact scaling depends on the normalization used for the periodogram.
}
\value{
Returns a numeric vector of the same size as \code{freq}, containing the corresponding powers of the OUSS process.
}
\references{
Louca, S., Doebeli, M. (2015) Detecting cyclicity in ecological time series, Ecology 96: 1724--1732
}
\author{
Stilianos Louca
}
\note{
This function is the asymptotic version of \code{\link{ps_ouss}} in the limit where \code{series_size} becomes very large. If you want to compare the expected periodogram to the periodogram of a short time series use \code{\link{ps_ouss}} instead.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{evaluate.pm}}, \code{\link{generate_ouss}}
}
\examples{
# generate OUSS time series
times  = seq(0,20,0.25);
signal = generate_ouss(times, mu=0, sigma=1, lambda=1, epsilon=0.5);

# calculate periodogram and fit OUSS model
report = evaluate.pm(times=times, signal=signal, startRadius=2);

# plot periodogram
plot(report$frequencies, report$periodogram, 
     type="l", ylab="power", xlab="frequency", main="periodogram & fitted OUSS power spectrum");

# plot OUSS power spectrum
lines(report$frequencies, 
      ps_ouss_asymptotic( freq=report$frequencies, 
                          power_o=report$power_o, 
                          lambda=report$lambda, 
                          power_e=report$power_e, 
                          time_step=report$time_step), 
      col="red");

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
