#' @keywords internal
pdRegression <- function(object, pred.var, pred.grid, train, ...) {
  UseMethod("pdRegression")
}


#' @keywords internal
pdRegression.default <- function(object, pred.var, pred.grid, train,
                                 ...) {
  plyr::adply(pred.grid, .margins = 1, .fun = function(x) {
    temp <- train
    temp[pred.var] <- x
    pred <- stats::predict(object, newdata = temp)
    # Some fitting function return a matrix (e.g., mda::mars)
    if (is.matrix(pred) || is.data.frame(pred)) {
      pred <- pred[, 1L, drop = TRUE]
    }
    mean(pred, na.rm = TRUE)
  }, ...)
}


#' @keywords internal
pdRegression.gbm <- function(object, pred.var, pred.grid, train,
                                 ...) {
  # Necessary to avoid silly printing from predict.gbm
  plyr::adply(pred.grid, .margins = 1, .fun = function(x) {
    temp <- train
    temp[pred.var] <- x
    log <- utils::capture.output(z <- mean(stats::predict(object,
                                                          newdata = temp),
                                           na.rm = TRUE))
    z
  }, ...)
}


#' @keywords internal
pdRegression.xgb.Booster <- function(object, pred.var, pred.grid, train, ...) {
  plyr::adply(pred.grid, .margins = 1, .fun = function(x) {
    temp <- train
    temp[pred.var] <- x
    mean(stats::predict(object, newdata = data.matrix(temp)), na.rm = TRUE)
  }, ...)
}
