% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdSpecEst.R
\docType{package}
\name{pdSpecEst}
\alias{pdSpecEst}
\alias{pdSpecEst-package}
\title{pdSpecEst: An Analysis Toolbox for Hermitian Positive Definite Matrices}
\description{
The \code{pdSpecEst} (\strong{p}ositive \strong{d}efinite \strong{Spec}tral \strong{Est}imation)
package provides data analysis tools for samples of symmetric or Hermitian positive definite matrices,
such as collections of positive definite covariance matrices or spectral density matrices.
}
\details{
The tools in this package can be used to perform:
\itemize{
   \item \emph{Intrinsic wavelet transforms} for curves (1D) and surfaces (2D) of Hermitian positive
   definite matrices, with applications to for instance: dimension reduction, denoising and clustering for curves or
   surfaces of Hermitian positive definite matrices, such as (time-varying) Fourier spectral density matrices.
   These implementations are based in part on the paper \insertCite{CvS17}{pdSpecEst} and Chapters 3
   and 5 of \insertCite{C18}{pdSpecEst}.
   \item Exploratory data analysis and inference for samples of Hermitian positive definite matrices by
   means of \emph{intrinsic data depth} and \emph{depth rank-based hypothesis tests}. These implementations are based
   on the paper \insertCite{COvS17}{pdSpecEst} and Chapter 4 of \insertCite{C18}{pdSpecEst}.
 }
For more details and examples on how to use the package see the accompanying vignettes in the vignettes folder.
An R-Shiny app to demonstrate and test the implemented functionality in the package is available
\href{https://jchau.shinyapps.io/pdSpecEst/}{here}.

Author and maintainer: \strong{Joris Chau} (\email{j.chau@uclouvain.be}).

Install the current development version via \code{devtools::install_github("JorisChau/pdSpecEst")}.
}
\references{
\insertAllCited{}
}
