% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavtrans.R
\name{WavTransf}
\alias{WavTransf}
\title{Forward MI wavelet transform}
\usage{
WavTransf(P, order = 5, jmax)
}
\arguments{
\item{P}{a (\eqn{d,d,m})-dimensional array of Hermitian PD matrices, with \eqn{m = 2^J} for some \eqn{J > 0}.}

\item{order}{an odd integer between 1 and 9 corresponding to the order of the MI refinement scheme.}

\item{jmax}{the maximum scale up to which the wavelet coefficients are computed. If \code{jmax} is not
specified it is set equal to the maximum possible scale \code{jmax = J-1}.}
}
\value{
The function returns a list with two components:
\item{D }{a list of arrays, where each (\eqn{d, d, 2^j})-dimensional array contains the (\eqn{d \times d})-
dimensional wavelet coefficients at the \eqn{2^j} different locations in the given wavelet scale. The first
list element is a (\eqn{d, d, 2})-dimensional array containing the (\eqn{d \times d})-dimensional midpoints
at the coarsest scale (\eqn{j = 1}) in the midpoint pyramid.}
\item{M }{a list of arrays, where each (\eqn{d, d, 2^j})-dimensional array contains the (\eqn{d \times d})-
dimensional midpoints at the \eqn{2^j} different locations in the given midpoint scale. The first list
element is equivalent to the first list element in the \code{$D} component.}
}
\description{
\code{WavTransf} computes the forward \emph{midpoint-interpolation} (MI) wavelet transform of a
curve of length \eqn{m} of (\eqn{d \times d})-dimensional Hermitian PD matrices as described in
(Chau and von Sachs, 2017).
}
\examples{
## ARMA(1,1) process: Example 11.4.1 in (Brockwell and Davis, 1991)

Phi <- array(c(0.7, 0, 0, 0.6, rep(0, 4)), dim = c(2, 2, 2))
Theta <- array(c(0.5, -0.7, 0.6, 0.8, rep(0, 4)), dim = c(2, 2, 2))
Sigma <- matrix(c(1, 0.71, 0.71, 2), nrow = 2)
ts.sim <- rARMA(2^10, 2, Phi, Theta, Sigma)
ts.plot(ts.sim$X) # plot generated time series traces.

pgram <- pdPgram(ts.sim$X)
D <- WavTransf(pgram$P)

}
\references{
Chau, J. and von Sachs, R. (2017). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.

Brockwell, P.J. and Davis, R.A. (1991). \emph{Time series: Theory and Methods}. New York: Springer.
}
\seealso{
\code{\link{InvWavTransf}}, \code{\link{pdSpecEst}}
}
