% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_fun.R
\name{.pcr_plot_analyze}
\alias{.pcr_plot_analyze}
\title{Plotting function}
\usage{
.pcr_plot_analyze(df, method, facets = FALSE)
}
\arguments{
\item{df}{A data.frame such as this returned by \link{pcr_analyze}}

\item{method}{A character string. Possible input includes 'delta_delta_ct',
'delta_ct' or 'relative_curve'}

\item{facets}{A logical of whether or not to use facets when applicable}
}
\value{
A ggplot object. A bar graph of caculated ge
}
\description{
Plotting function
}
\examples{
## locate and read raw ct data
fl <- system.file('extdata', 'ct1.csv', package = 'pcr')
ct1 <- read.csv(fl)

# add grouping variable
group_var <- rep(c('brain', 'kidney'), each = 6)

# calculate all delta_delta_ct model
df <- pcr_ddct(ct1,
               group_var = group_var,
               reference_gene = 'GAPDH',
               reference_group = 'brain')

# make a plot
pcr:::.pcr_plot_analyze(df, method = 'delta_delta_ct')

# make a data.frame of two identical columns
pcr_hk <- data.frame(
  GAPDH1 = ct1$GAPDH,
  GAPDH2 = ct1$GAPDH
  )

# calculate delta_ct model
df <- pcr_dct(pcr_hk,
              group_var = group_var,
              reference_group = 'brain')

# make a plot
pcr:::.pcr_plot_analyze(df, method = 'delta_ct')
pcr:::.pcr_plot_analyze(df, method = 'delta_ct', facet = TRUE)

# calculate curve
# locate and read data
fl <- system.file('extdata', 'ct3.csv', package = 'pcr')
ct3 <- read.csv(fl)

# make a vector of RNA amounts
amount <- rep(c(1, .5, .2, .1, .05, .02, .01), each = 3)

standard_curve <- pcr_assess(ct3,
                             amount = amount,
                             method = 'standard_curve')
intercept <- standard_curve$intercept
slope <- standard_curve$slope

# calculate the rellative_curve model
df <- pcr_curve(ct1,
                group_var = group_var,
                reference_gene = 'GAPDH',
                reference_group = 'brain',
                intercept = intercept,
                slope = slope)

# make a plot
pcr:::.pcr_plot_analyze(df, method = 'relative_curve')

}
\keyword{internal}
