% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodfuns.R
\name{coef.pcoxtimecv}
\alias{coef.pcoxtimecv}
\alias{coefficients.pcoxtimecv}
\title{Extract coefficient estimates of pcoxtimecv object}
\usage{
\method{coef}{pcoxtimecv}(object, lambda, ...)

\method{coefficients}{pcoxtimecv}(object, lambda, ...)
}
\arguments{
\item{object}{\code{\link[pcoxtime]{pcoxtimecv}} object}

\item{lambda}{the value of lambda for which to return the coefficient estimates. It can be any of the character string, "min", "optimal" or "best" for optimal lambda; "1se" for 1 standard error lambda; or any numeric value for lambda. See details.}

\item{...}{for future implementations}
}
\value{
A data frame of coefficient estimates.

A vector of coefficient estimates.
}
\description{
This function extracts cross-validation estimates for a particular lambda.
}
\details{
Extract the coefficient estimates for optimal lambda-alpha pair or based on specified the value of lambda for an optimal alpha. If the value of lambda specified is not exact (not in lambdas), the nearest value is used, based on \code{nearest <- function(values, value){values[which(abs(values-value)==min(abs(values-value)))]}}. It requires that \code{\link[pcoxtime]{pcoxtimecv}} is run with \code{refit = TRUE}.
}
