% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{plotPEregs.int}
\alias{plotPEregs.int}
\title{The plot of the Proportional Edge (PE) Proximity Regions for a general interval
(vertices jittered along \eqn{y}-coordinate) - one interval case}
\usage{
plotPEregs.int(
  Xp,
  int,
  r,
  c = 0.5,
  Jit = 0.1,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  center = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 1D points for which PE proximity regions are to be constructed.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{Jit}{A positive real number that determines the amount of jitter along the \eqn{y}-axis, default=\code{0.1} and
\code{Xp} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the \eqn{y}-axis where \code{Jit} equals to the range of \code{Xp} and proximity region
intervals multiplied by \code{Jit}).}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges.}

\item{center}{A logical argument, if \code{TRUE}, plot includes the center of the interval
as a vertical line in the plot, else center of the interval is not plotted.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the PE proximity regions for 1D points in or outside the interval \code{int}
}
\description{
Plots the points in and outside of the interval \code{int} and also the PE proximity regions (which are also intervals).
PE proximity regions are constructed with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}.

For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)} (default is \eqn{Jit=.1}) times range of proximity
regions and \code{Xp}) is added to the \eqn{y}-direction.
\code{center} is a logical argument, if \code{TRUE}, plot includes the
center of the interval as a vertical line in the plot, else center of the interval is not plotted.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

n<-10
xf<-(int[2]-int[1])*.1
Xp<-runif(n,a-xf,b+xf)  #try also Xp<-runif(n,a-5,b+5)
plotPEregs.int(Xp,int,r,c,xlab="x",ylab="")

plotPEregs.int(7,int,r,c,xlab="x",ylab="")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregs1D}}, \code{\link{plotCSregs.int}}, and \code{\link{plotCSregs.int}}
}
\author{
Elvan Ceyhan
}
