% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{NumArcsAStri}
\alias{NumArcsAStri}
\title{Number of arcs of Arc Slice Proximity Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
NumArcsAStri(Xp, tri, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the digraph (i.e., AS-PCD).}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Number of arcs of the AS-PCD}
\item{num.in.tri}{Number of \code{Xp} points in the triangle, \code{tri}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points that reside in the triangle}
}
\description{
Returns the number of arcs of Arc Slice Proximity Catch Digraphs (AS-PCDs)
whose vertices are the 2D data set, \code{Xp}. It also provides number of vertices (i.e., number of data points inside the triangle)
and indices of the data points that reside in the triangle.

The data points could be inside or outside a general
triangle \code{tri}\eqn{=T(A,B,C)=}\code{(rv=1,rv=2,rv=3)}, with vertices of \code{tri} stacked row-wise.

AS proximity regions are defined with respect to the triangle \code{tri} and vertex regions are
based on the center \code{M="CC"} for circumcenter of \code{tri};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of the triangle \code{tri}; default is \code{M="CC"} i.e., circumcenter of \code{tri}.
For the number of arcs, loops are not allowed,
so arcs are only possible for points inside the triangle, \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-10  #try also n<-20
set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

NumArcsAStri(Xp,Tr,M)

Xp2=Xp+1
NumArcsAStri(Xp2,Tr,M)

NumArcsAStri(rbind(Xp,c(0,2)),Tr,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsAS}}, \code{\link{NumArcsPEtri}}, and \code{\link{NumArcsCStri}}
}
\author{
Elvan Ceyhan
}
