% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotDeltri}
\alias{plotDeltri}
\title{The scatterplot of points from one class and plot of the Delaunay triangulation of the other class}
\usage{
plotDeltri(
  Xp,
  Yp,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points whose scatterplot is to be plotted}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles}

\item{main}{An overall title for the plot (default="")}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both)}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges (default=\code{NULL} for both)}

\item{\dots}{Additional \code{plot} parameters}
}
\value{
A scatterplot of \code{Xp} points and the Delaunay triangulation of \code{Yp} points.
}
\description{
Plots the scatter plot of \code{Xp} points together with the Delaunay triangles based on the \code{Yp} points.
Both sets of points are of 2D.

See (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny),runif(ny))

oldpar <- par(mfrow = c(1,2))
plotDeltri(Xp,Yp,xlab="",ylab="",main="X points and Delaunay Triangulation of Y points")

P<-c(.6,.4)
plotDeltri(P,Yp,xlab="",ylab="",main="X points and Delaunay Triangulation of Y points")

plotDeltri(Xp,Yp,xlab="",ylab="")
plotDeltri(Xp,Yp[1:3,],xlab="",ylab="")

plotDeltri(Xp,rbind(Yp,Yp),xlab="",ylab="")

dat.fr<-data.frame(a=Xp)
plotDeltri(dat.fr,Yp,xlab="",ylab="")

dat.fr<-data.frame(a=Yp)
plotDeltri(Xp,dat.fr,xlab="",ylab="")
par(oldpar)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[interp]{plot.triSht}} in \code{interp} package
}
