% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_lu.r
\docType{methods}
\name{ddmatrix-lu}
\alias{ddmatrix-lu}
\alias{lu}
\alias{lu,ddmatrix-method}
\title{LU Factorization}
\usage{
\S4method{lu}{ddmatrix}(x)
}
\arguments{
\item{x}{numeric distributed matrices.}
}
\value{
\code{lu()} performs LU factorization.
}
\description{
LU factorization for distributed matrices with R-like syntax, with
calculations performed by the PBLAS and ScaLAPACK libraries.
}
\details{
Extensions of R linear algebra functions.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:9, 3)
x <- as.ddmatrix(x)

y <- solve(t(A) \%*\% A)
print(y)

finalize()
}

}
\keyword{Algebra}
\keyword{Linear}
\keyword{Methods}

