% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_[.r
\docType{methods}
\name{extract}
\alias{[,ddmatrix-method}
\alias{extract}
\title{Extract or Replace Parts of a Distributed Matrix}
\usage{
\S4method{[}{ddmatrix}(x, i, j, ICTXT)
}
\arguments{
\item{x}{numeric distributed matrix.}

\item{i, j}{indices specifying elements to extract or replace.  Indices can
be \code{numeric}, \code{character}, empty, or \code{NULL}.
number of elements for a vector (including lists), rows for a matrix or data
frame or lines for a function. If negative, all but the \code{n} last/first
number of elements of \code{x}.}

\item{ICTXT}{optional BLACS context number for output}

\item{...}{additional arguments.}
}
\value{
Returns a distributed matrix.
}
\description{
Operators to extract or replace parts of a distributed matrix.
}
\details{
\code{[} can be used to extract/replace for a distributed matrix exactly as
you would with an ordinary matrix.

The functions rely on reblocking across different BLACS contexts.  If
\code{i} is not empty, then the input distributed matrix will be
redistributed along context 1, where extracting/deleting rows does not
destroy block-cyclicality. Likewise, if \code{j} is not empty, then the
input distributed matrix will be redistributed along context 2. When
extraction is complete, the matrix will be redistributed across its input
context.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:9, 3, bldim=2)

y <- x[, -1]
y <- head(y, 2)
y

finalize()
}

}
\keyword{Extraction}
\keyword{Methods}

