% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{sesv2}
\alias{sesv2}
\title{Amazon Simple Email Service}
\usage{
sesv2(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon SES API v2

\href{https://aws.amazon.com/ses/}{Amazon SES} is an Amazon Web Services
service that you can use to send email messages to your customers.

If you're new to Amazon SES API v2, you might find it helpful to review
the \href{https://docs.aws.amazon.com/ses/latest/dg/Welcome.html}{Amazon Simple Email Service Developer Guide}. The
\emph{Amazon SES Developer Guide} provides information and code samples that
demonstrate how to use Amazon SES API v2 features programmatically.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- sesv2(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.customer.engagement:sesv2_batch_get_metric_data]{batch_get_metric_data} \tab Retrieves batches of metric data collected based on your sending activity\cr
\link[paws.customer.engagement:sesv2_cancel_export_job]{cancel_export_job} \tab Cancels an export job\cr
\link[paws.customer.engagement:sesv2_create_configuration_set]{create_configuration_set} \tab Create a configuration set\cr
\link[paws.customer.engagement:sesv2_create_configuration_set_event_destination]{create_configuration_set_event_destination} \tab Create an event destination\cr
\link[paws.customer.engagement:sesv2_create_contact]{create_contact} \tab Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list\cr
\link[paws.customer.engagement:sesv2_create_contact_list]{create_contact_list} \tab Creates a contact list\cr
\link[paws.customer.engagement:sesv2_create_custom_verification_email_template]{create_custom_verification_email_template} \tab Creates a new custom verification email template\cr
\link[paws.customer.engagement:sesv2_create_dedicated_ip_pool]{create_dedicated_ip_pool} \tab Create a new pool of dedicated IP addresses\cr
\link[paws.customer.engagement:sesv2_create_deliverability_test_report]{create_deliverability_test_report} \tab Create a new predictive inbox placement test\cr
\link[paws.customer.engagement:sesv2_create_email_identity]{create_email_identity} \tab Starts the process of verifying an email identity\cr
\link[paws.customer.engagement:sesv2_create_email_identity_policy]{create_email_identity_policy} \tab Creates the specified sending authorization policy for the given identity (an email address or a domain)\cr
\link[paws.customer.engagement:sesv2_create_email_template]{create_email_template} \tab Creates an email template\cr
\link[paws.customer.engagement:sesv2_create_export_job]{create_export_job} \tab Creates an export job for a data source and destination\cr
\link[paws.customer.engagement:sesv2_create_import_job]{create_import_job} \tab Creates an import job for a data destination\cr
\link[paws.customer.engagement:sesv2_create_multi_region_endpoint]{create_multi_region_endpoint} \tab Creates a multi-region endpoint (global-endpoint)\cr
\link[paws.customer.engagement:sesv2_delete_configuration_set]{delete_configuration_set} \tab Delete an existing configuration set\cr
\link[paws.customer.engagement:sesv2_delete_configuration_set_event_destination]{delete_configuration_set_event_destination} \tab Delete an event destination\cr
\link[paws.customer.engagement:sesv2_delete_contact]{delete_contact} \tab Removes a contact from a contact list\cr
\link[paws.customer.engagement:sesv2_delete_contact_list]{delete_contact_list} \tab Deletes a contact list and all of the contacts on that list\cr
\link[paws.customer.engagement:sesv2_delete_custom_verification_email_template]{delete_custom_verification_email_template} \tab Deletes an existing custom verification email template\cr
\link[paws.customer.engagement:sesv2_delete_dedicated_ip_pool]{delete_dedicated_ip_pool} \tab Delete a dedicated IP pool\cr
\link[paws.customer.engagement:sesv2_delete_email_identity]{delete_email_identity} \tab Deletes an email identity\cr
\link[paws.customer.engagement:sesv2_delete_email_identity_policy]{delete_email_identity_policy} \tab Deletes the specified sending authorization policy for the given identity (an email address or a domain)\cr
\link[paws.customer.engagement:sesv2_delete_email_template]{delete_email_template} \tab Deletes an email template\cr
\link[paws.customer.engagement:sesv2_delete_multi_region_endpoint]{delete_multi_region_endpoint} \tab Deletes a multi-region endpoint (global-endpoint)\cr
\link[paws.customer.engagement:sesv2_delete_suppressed_destination]{delete_suppressed_destination} \tab Removes an email address from the suppression list for your account\cr
\link[paws.customer.engagement:sesv2_get_account]{get_account} \tab Obtain information about the email-sending status and capabilities of your Amazon SES account in the current Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_get_blacklist_reports]{get_blacklist_reports} \tab Retrieve a list of the blacklists that your dedicated IP addresses appear on\cr
\link[paws.customer.engagement:sesv2_get_configuration_set]{get_configuration_set} \tab Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more\cr
\link[paws.customer.engagement:sesv2_get_configuration_set_event_destinations]{get_configuration_set_event_destinations} \tab Retrieve a list of event destinations that are associated with a configuration set\cr
\link[paws.customer.engagement:sesv2_get_contact]{get_contact} \tab Returns a contact from a contact list\cr
\link[paws.customer.engagement:sesv2_get_contact_list]{get_contact_list} \tab Returns contact list metadata\cr
\link[paws.customer.engagement:sesv2_get_custom_verification_email_template]{get_custom_verification_email_template} \tab Returns the custom email verification template for the template name you specify\cr
\link[paws.customer.engagement:sesv2_get_dedicated_ip]{get_dedicated_ip} \tab Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address\cr
\link[paws.customer.engagement:sesv2_get_dedicated_ip_pool]{get_dedicated_ip_pool} \tab Retrieve information about the dedicated pool\cr
\link[paws.customer.engagement:sesv2_get_dedicated_ips]{get_dedicated_ips} \tab List the dedicated IP addresses that are associated with your Amazon Web Services account\cr
\link[paws.customer.engagement:sesv2_get_deliverability_dashboard_options]{get_deliverability_dashboard_options} \tab Retrieve information about the status of the Deliverability dashboard for your account\cr
\link[paws.customer.engagement:sesv2_get_deliverability_test_report]{get_deliverability_test_report} \tab Retrieve the results of a predictive inbox placement test\cr
\link[paws.customer.engagement:sesv2_get_domain_deliverability_campaign]{get_domain_deliverability_campaign} \tab Retrieve all the deliverability data for a specific campaign\cr
\link[paws.customer.engagement:sesv2_get_domain_statistics_report]{get_domain_statistics_report} \tab Retrieve inbox placement and engagement rates for the domains that you use to send email\cr
\link[paws.customer.engagement:sesv2_get_email_identity]{get_email_identity} \tab Provides information about a specific identity, including the identity's verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings\cr
\link[paws.customer.engagement:sesv2_get_email_identity_policies]{get_email_identity_policies} \tab Returns the requested sending authorization policies for the given identity (an email address or a domain)\cr
\link[paws.customer.engagement:sesv2_get_email_template]{get_email_template} \tab Displays the template object (which includes the subject line, HTML part and text part) for the template you specify\cr
\link[paws.customer.engagement:sesv2_get_export_job]{get_export_job} \tab Provides information about an export job\cr
\link[paws.customer.engagement:sesv2_get_import_job]{get_import_job} \tab Provides information about an import job\cr
\link[paws.customer.engagement:sesv2_get_message_insights]{get_message_insights} \tab Provides information about a specific message, including the from address, the subject, the recipient address, email tags, as well as events associated with the message\cr
\link[paws.customer.engagement:sesv2_get_multi_region_endpoint]{get_multi_region_endpoint} \tab Displays the multi-region endpoint (global-endpoint) configuration\cr
\link[paws.customer.engagement:sesv2_get_suppressed_destination]{get_suppressed_destination} \tab Retrieves information about a specific email address that's on the suppression list for your account\cr
\link[paws.customer.engagement:sesv2_list_configuration_sets]{list_configuration_sets} \tab List all of the configuration sets associated with your account in the current region\cr
\link[paws.customer.engagement:sesv2_list_contact_lists]{list_contact_lists} \tab Lists all of the contact lists available\cr
\link[paws.customer.engagement:sesv2_list_contacts]{list_contacts} \tab Lists the contacts present in a specific contact list\cr
\link[paws.customer.engagement:sesv2_list_custom_verification_email_templates]{list_custom_verification_email_templates} \tab Lists the existing custom verification email templates for your account in the current Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_list_dedicated_ip_pools]{list_dedicated_ip_pools} \tab List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region\cr
\link[paws.customer.engagement:sesv2_list_deliverability_test_reports]{list_deliverability_test_reports} \tab Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses\cr
\link[paws.customer.engagement:sesv2_list_domain_deliverability_campaigns]{list_domain_deliverability_campaigns} \tab Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range\cr
\link[paws.customer.engagement:sesv2_list_email_identities]{list_email_identities} \tab Returns a list of all of the email identities that are associated with your Amazon Web Services account\cr
\link[paws.customer.engagement:sesv2_list_email_templates]{list_email_templates} \tab Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_list_export_jobs]{list_export_jobs} \tab Lists all of the export jobs\cr
\link[paws.customer.engagement:sesv2_list_import_jobs]{list_import_jobs} \tab Lists all of the import jobs\cr
\link[paws.customer.engagement:sesv2_list_multi_region_endpoints]{list_multi_region_endpoints} \tab List the multi-region endpoints (global-endpoints)\cr
\link[paws.customer.engagement:sesv2_list_recommendations]{list_recommendations} \tab Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_list_suppressed_destinations]{list_suppressed_destinations} \tab Retrieves a list of email addresses that are on the suppression list for your account\cr
\link[paws.customer.engagement:sesv2_list_tags_for_resource]{list_tags_for_resource} \tab Retrieve a list of the tags (keys and values) that are associated with a specified resource\cr
\link[paws.customer.engagement:sesv2_put_account_dedicated_ip_warmup_attributes]{put_account_dedicated_ip_warmup_attributes} \tab Enable or disable the automatic warm-up feature for dedicated IP addresses\cr
\link[paws.customer.engagement:sesv2_put_account_details]{put_account_details} \tab Update your Amazon SES account details\cr
\link[paws.customer.engagement:sesv2_put_account_sending_attributes]{put_account_sending_attributes} \tab Enable or disable the ability of your account to send email\cr
\link[paws.customer.engagement:sesv2_put_account_suppression_attributes]{put_account_suppression_attributes} \tab Change the settings for the account-level suppression list\cr
\link[paws.customer.engagement:sesv2_put_account_vdm_attributes]{put_account_vdm_attributes} \tab Update your Amazon SES account VDM attributes\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_delivery_options]{put_configuration_set_delivery_options} \tab Associate a configuration set with a dedicated IP pool\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_reputation_options]{put_configuration_set_reputation_options} \tab Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_sending_options]{put_configuration_set_sending_options} \tab Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web Services Region\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_suppression_options]{put_configuration_set_suppression_options} \tab Specify the account suppression list preferences for a configuration set\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_tracking_options]{put_configuration_set_tracking_options} \tab Specify a custom domain to use for open and click tracking elements in email that you send\cr
\link[paws.customer.engagement:sesv2_put_configuration_set_vdm_options]{put_configuration_set_vdm_options} \tab Specify VDM preferences for email that you send using the configuration set\cr
\link[paws.customer.engagement:sesv2_put_dedicated_ip_in_pool]{put_dedicated_ip_in_pool} \tab Move a dedicated IP address to an existing dedicated IP pool\cr
\link[paws.customer.engagement:sesv2_put_dedicated_ip_pool_scaling_attributes]{put_dedicated_ip_pool_scaling_attributes} \tab Used to convert a dedicated IP pool to a different scaling mode\cr
\link[paws.customer.engagement:sesv2_put_dedicated_ip_warmup_attributes]{put_dedicated_ip_warmup_attributes} \tab Put dedicated ip warmup attributes\cr
\link[paws.customer.engagement:sesv2_put_deliverability_dashboard_option]{put_deliverability_dashboard_option} \tab Enable or disable the Deliverability dashboard\cr
\link[paws.customer.engagement:sesv2_put_email_identity_configuration_set_attributes]{put_email_identity_configuration_set_attributes} \tab Used to associate a configuration set with an email identity\cr
\link[paws.customer.engagement:sesv2_put_email_identity_dkim_attributes]{put_email_identity_dkim_attributes} \tab Used to enable or disable DKIM authentication for an email identity\cr
\link[paws.customer.engagement:sesv2_put_email_identity_dkim_signing_attributes]{put_email_identity_dkim_signing_attributes} \tab Used to configure or change the DKIM authentication settings for an email domain identity\cr
\link[paws.customer.engagement:sesv2_put_email_identity_feedback_attributes]{put_email_identity_feedback_attributes} \tab Used to enable or disable feedback forwarding for an identity\cr
\link[paws.customer.engagement:sesv2_put_email_identity_mail_from_attributes]{put_email_identity_mail_from_attributes} \tab Used to enable or disable the custom Mail-From domain configuration for an email identity\cr
\link[paws.customer.engagement:sesv2_put_suppressed_destination]{put_suppressed_destination} \tab Adds an email address to the suppression list for your account\cr
\link[paws.customer.engagement:sesv2_send_bulk_email]{send_bulk_email} \tab Composes an email message to multiple destinations\cr
\link[paws.customer.engagement:sesv2_send_custom_verification_email]{send_custom_verification_email} \tab Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it\cr
\link[paws.customer.engagement:sesv2_send_email]{send_email} \tab Sends an email message\cr
\link[paws.customer.engagement:sesv2_tag_resource]{tag_resource} \tab Add one or more tags (keys and values) to a specified resource\cr
\link[paws.customer.engagement:sesv2_test_render_email_template]{test_render_email_template} \tab Creates a preview of the MIME content of an email when provided with a template and a set of replacement data\cr
\link[paws.customer.engagement:sesv2_untag_resource]{untag_resource} \tab Remove one or more tags (keys and values) from a specified resource\cr
\link[paws.customer.engagement:sesv2_update_configuration_set_event_destination]{update_configuration_set_event_destination} \tab Update the configuration of an event destination for a configuration set\cr
\link[paws.customer.engagement:sesv2_update_contact]{update_contact} \tab Updates a contact's preferences for a list\cr
\link[paws.customer.engagement:sesv2_update_contact_list]{update_contact_list} \tab Updates contact list metadata\cr
\link[paws.customer.engagement:sesv2_update_custom_verification_email_template]{update_custom_verification_email_template} \tab Updates an existing custom verification email template\cr
\link[paws.customer.engagement:sesv2_update_email_identity_policy]{update_email_identity_policy} \tab Updates the specified sending authorization policy for the given identity (an email address or a domain)\cr
\link[paws.customer.engagement:sesv2_update_email_template]{update_email_template} \tab Updates an email template
}
}

\examples{
\dontrun{
svc <- sesv2()
svc$batch_get_metric_data(
  Foo = 123
)
}

}
