% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{connectcampaignservice}
\alias{connectcampaignservice}
\title{AmazonConnectCampaignService}
\usage{
connectcampaignservice(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Provide APIs to create and manage Amazon Connect Campaigns.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- connectcampaignservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.customer.engagement:connectcampaignservice_create_campaign]{create_campaign} \tab Creates a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_delete_campaign]{delete_campaign} \tab Deletes a campaign from the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_delete_connect_instance_config]{delete_connect_instance_config} \tab Deletes a connect instance config from the specified AWS account\cr
\link[paws.customer.engagement:connectcampaignservice_delete_instance_onboarding_job]{delete_instance_onboarding_job} \tab Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance\cr
\link[paws.customer.engagement:connectcampaignservice_describe_campaign]{describe_campaign} \tab Describes the specific campaign\cr
\link[paws.customer.engagement:connectcampaignservice_get_campaign_state]{get_campaign_state} \tab Get state of a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_get_campaign_state_batch]{get_campaign_state_batch} \tab Get state of campaigns for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_get_connect_instance_config]{get_connect_instance_config} \tab Get the specific Connect instance config\cr
\link[paws.customer.engagement:connectcampaignservice_get_instance_onboarding_job_status]{get_instance_onboarding_job_status} \tab Get the specific instance onboarding job status\cr
\link[paws.customer.engagement:connectcampaignservice_list_campaigns]{list_campaigns} \tab Provides summary information about the campaigns under the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a resource\cr
\link[paws.customer.engagement:connectcampaignservice_pause_campaign]{pause_campaign} \tab Pauses a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_put_dial_request_batch]{put_dial_request_batch} \tab Creates dials requests for the specified campaign Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_resume_campaign]{resume_campaign} \tab Stops a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_start_campaign]{start_campaign} \tab Starts a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_start_instance_onboarding_job]{start_instance_onboarding_job} \tab Onboard the specific Amazon Connect instance to Connect Campaigns\cr
\link[paws.customer.engagement:connectcampaignservice_stop_campaign]{stop_campaign} \tab Stops a campaign for the specified Amazon Connect account\cr
\link[paws.customer.engagement:connectcampaignservice_tag_resource]{tag_resource} \tab Tag a resource\cr
\link[paws.customer.engagement:connectcampaignservice_untag_resource]{untag_resource} \tab Untag a resource\cr
\link[paws.customer.engagement:connectcampaignservice_update_campaign_dialer_config]{update_campaign_dialer_config} \tab Updates the dialer config of a campaign\cr
\link[paws.customer.engagement:connectcampaignservice_update_campaign_name]{update_campaign_name} \tab Updates the name of a campaign\cr
\link[paws.customer.engagement:connectcampaignservice_update_campaign_outbound_call_config]{update_campaign_outbound_call_config} \tab Updates the outbound call config of a campaign
}
}

\examples{
\dontrun{
svc <- connectcampaignservice()
svc$create_campaign(
  Foo = 123
)
}

}
